package com.mm214.gridviewapplication;
import android.os.Bundle;
import android.os.Environment;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.TextView;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

public class MainActivity extends Activity {

    //List <String> ImageList;
    String arrData[][];

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // get Data from SQLite
        final myDBClass myDb = new myDBClass(this);



        arrData = myDb.SelectAllData();
        /***
         *  [x][0] = GalleryID
         *  [x][1] = Name
         *  [x][2] = Path
         */

        // gridView1
        final GridView gView1 = (GridView)findViewById(R.id.gridView1);

        gView1.setAdapter(new ImageAdapter(this,arrData));

        final AlertDialog.Builder imageDialog = new AlertDialog.Builder(this);
        final LayoutInflater inflater = (LayoutInflater) this.getSystemService(LAYOUT_INFLATER_SERVICE);

        // OnClick
        gView1.setOnItemClickListener(new OnItemClickListener() {
            public void onItemClick(AdapterView<?> parent, View v,
                                    int position, long id) {

                View layout = inflater.inflate(R.layout.custom_fullimage_dialog,
                        (ViewGroup) findViewById(R.id.layout_root));
                ImageView image = (ImageView) layout.findViewById(R.id.fullimage);
                String prePend = Environment.getExternalStorageDirectory();
                String strPath = prePend +arrData[position][2].toString();
                Bitmap bm = BitmapFactory.decodeFile(strPath);
                int width=200;
                int height=200;
                Bitmap resizedbitmap = Bitmap.createScaledBitmap(bm, width, height, true);
                image.setImageBitmap(resizedbitmap);

                imageDialog.setIcon(android.R.drawable.btn_star_big_on);
                imageDialog.setTitle("View : " + arrData[position][1].toString());
                imageDialog.setView(layout);
                imageDialog.setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }

                });


                imageDialog.create();
                imageDialog.show();

            }
        });

    }

    public class ImageAdapter extends BaseAdapter
    {
        private Context context;
        private String[][] lis;

        public ImageAdapter(Context c, String[][] li)
        {
            // TODO Auto-generated method stub
            context = c;
            lis = li;
        }

        public int getCount() {
            // TODO Auto-generated method stub
            return lis.length;
        }

        public Object getItem(int position) {
            // TODO Auto-generated method stub
            return position;
        }

        public long getItemId(int position) {
            // TODO Auto-generated method stub
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            // TODO Auto-generated method stub

            LayoutInflater inflater = (LayoutInflater) context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);


            if (convertView == null) {
                convertView = inflater.inflate(R.layout.showimage, null);
            }

            TextView textView = (TextView) convertView.findViewById(R.id.textView1);
            String strPath = Environment.getExternalStorageDirectory()  +lis[position][2].toString();

            textView.setText(lis[position][1].toString());

            // Image Resource
            ImageView imageView = (ImageView) convertView.findViewById(R.id.imageView1);
            Bitmap bm = BitmapFactory.decodeFile(strPath);
            imageView.setImageBitmap(bm);


            return convertView;

        }
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

}