package com.javapapers.android.sqlitestorageoption;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import com.javapapers.android.sqlitestorageoption.R;
import android.provider.MediaStore;
import android.content.Context;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;

import android.util.Log;
import android.view.View;
import android.widget.EditText;
import java.io.File;
import android.net.Uri;
import android.os.Environment;
import android.widget.Toast;




public class NewAnimal extends Activity {
    EditText animalName;
    DBController controller = new DBController(this);
    static int TAKE_PICTURE = 1;
    Uri outputFileUri;
    final Context context = this;
    public String lastId;
    public String picName;

    /**
     * Database name
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.add_new_animal);
        animalName = (EditText) findViewById(R.id.animalName);
    }

    public void btnTakePhoto(View view) {
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        long seconds = System.currentTimeMillis() / 1000;
        String pic = Long.toString(seconds);
        picName = pic + ".jpg";
        File file = new File(Environment.getExternalStorageDirectory(), picName);
        outputFileUri = Uri.fromFile(file);
        intent.putExtra(MediaStore.EXTRA_OUTPUT, outputFileUri);
        Log.v("MYPIC", outputFileUri.toString());
        startActivityForResult(intent, TAKE_PICTURE);
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == TAKE_PICTURE && resultCode == RESULT_OK) {
            Toast.makeText(this, outputFileUri.toString(), Toast.LENGTH_LONG).show();
            //controller.InsertData(picName,  outputFileUri.toString());
            HashMap<String, String> queryValues = new HashMap<String, String>();
            queryValues.put("animalName", outputFileUri.toString());
            controller.insertAnimal(queryValues);

        }

    }


}
