
import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.webkit.WebView;
import android.widget.Toast;

public class MainActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	@SuppressLint("NewApi")
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {

		switch (item.getItemId()) {

		case R.id.map:
			mapActivity();
			return true;

		case R.id.camera:
			cameraActivity();
			return true;

		case R.id.shopping:
			shoppingActivity();
			return true;

		default:
			return super.onOptionsItemSelected(item);
		}

	}

	public void mapActivity() {
		Toast.makeText(this, "Map Option Selected", Toast.LENGTH_SHORT).show();
	}

	public void cameraActivity() {
		Toast.makeText(this, "Camera Option Selected", Toast.LENGTH_SHORT).show();
	}

	public void shoppingActivity() {
		Toast.makeText(this, "Shopping Option Selected", Toast.LENGTH_SHORT).show();
	}

}