package com.mm214.intentexample;

import com.mm214.intentexample.R;

import android.net.Uri;
import android.os.Bundle;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.view.Menu;
import android.view.View;

public class MainActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

    //OnClick listener for ExplicitIntent button
	public void onClickExplicitIntent(View V)
	{
	    // Create The Explicit Intent and Start The Activity
		// here you force explicitly to start SecondActivity.
	    Intent intentExplicit =new Intent(this,SecondActivity.class);
	    intentExplicit.putExtra("First Value", "This First Value for ActivityTwo"); // optional
	    intentExplicit.putExtra("Second Value", "This Second Value for ActivityTwo"); //optional
	    startActivity(intentExplicit);// Activity is started using explicit intent.
	}
	
	//OnClick listener for implicitIntent button
	public void onClickImplicitIntent(View V)
	{
	    // Create The  Implicit Intent and send request to Browser component
		//to start a web browser
		//here you request implicitly to Android OS to start a web browser.
		Intent intentImplicit = new Intent(Intent.ACTION_VIEW, Uri.parse("http://www.mm214.com"));
		try { 
	          startActivity(intentImplicit);
			} catch (ActivityNotFoundException ex) { 
				//do something here
			}
	}
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
    
}
