
import java.text.*;
import java.util.*;

public class Week2HW {
	
	final double interestRate = .015;
	Scanner input = new Scanner(System.in);
	
	public static void main(String[] args) {
		Week2HW week2HW = new Week2HW();
		Double goalAmt;
		Double numYears;
		Double currentSavings;
		Double weeklySavings;
		
		String prompt = "Your financial goal calculation\nPlease enter a number value amount for you financial goal: ";
		goalAmt = week2HW.validateResponse(prompt);
		
		if(goalAmt!=null)
		{
			prompt = "Please enter the number of years planned to reach your financial goal: ";
			numYears  = week2HW.validateResponse(prompt);
			if(numYears!=null)
			{
				prompt = "Enter your current savings amount: ";
				currentSavings = week2HW.validateResponse(prompt);
				if(currentSavings!=null)
				{	
					prompt = "Enter amount you save per week: ";
					weeklySavings = week2HW.validateResponse(prompt);
					if(weeklySavings!=null)
					{
						week2HW.calulateGoal(goalAmt, numYears, currentSavings, weeklySavings);
					}
				}
			}
		}
		
		week2HW.input.close();
		
		System.out.println("\n--------------\nPrinting Yardage...if ternary operator isn't technically a conditional");
		printYardage();
	}
	
	private void calulateGoal(Double goalAmt, Double numYears, Double currentSavings, Double weeklySavings)
	{
		Double result = currentSavings;
		DecimalFormat df = new DecimalFormat("#.##");
		
		for(int i=1;i<=numYears;i++)
		{
			result+=weeklySavings*52*(1+interestRate);
			//System.out.println("Total savings after year: "+i+" = "+result);
		}
		if(result>=goalAmt)
			System.out.println("You will reach your goal. With interest rate at "+(interestRate*100)+ "%APR, you will have: "+df.format(result));
		else
		{
			weeklySavings = (goalAmt-currentSavings)/(52*numYears*(1+interestRate));
			System.out.println("Youll never make it at this rate("+(interestRate*100)+"%APR), you need to save $"+df.format(weeklySavings)+ " more each week");
		}
	}
	
	private Double validateResponse(String prompt)
	{
		System.out.print(prompt);
		try{
			
			String response = input.nextLine();
			if(response!=null && !response.isEmpty())
			{
				return Double.parseDouble(response);
			}
			else
			{
				System.out.println("Empty response");
				return null;
			}
			
		}
		catch(Exception ex)
		{ 
			System.out.println("Invalid response");
			return null;	
		}
	}
	
	private static void printYardage()
	{
		//Output 10 20 30 40 50 40 30 20 10
		String output = "Yardage";
		for(int i=1;i<=9;i++)
		{
			int val = (i <=5 ) ? i*10: (i-((i-5)*2))*10;
			output = output+ " "+val;
		}
		System.out.println(output);
	}

}
