/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import java.io.IOException;

class ResourceBitmapHunter
extends BitmapHunter {
    private final Context context;

    ResourceBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.context = context;
    }

    @Override
    Bitmap decode(Request data) throws IOException {
        return this.decodeResource(this.context.getResources(), data);
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.DISK;
    }

    private Bitmap decodeResource(Resources resources, Request data) {
        int resourceId = data.resourceId;
        BitmapFactory.Options bitmapOptions = null;
        if (data.hasSize()) {
            bitmapOptions = new BitmapFactory.Options();
            bitmapOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)bitmapOptions);
            ResourceBitmapHunter.calculateInSampleSize(data.targetWidth, data.targetHeight, bitmapOptions);
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)bitmapOptions);
    }
}

