package com.mm214.cameratest;

import java.io.File;
import android.app.Activity;
import android.app.Dialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.view.View;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

public class MainActivity extends Activity {
	static int TAKE_PICTURE = 1;
	Uri outputFileUri;
	   public double latitude;
	    public double longitude;
		final Context context = this;
		SQLiteDatabase mydb;
	    public String lastId;  
	    public String picName;

	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //---------
    	Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
    	long seconds = System.currentTimeMillis() / 1000;
    	String pic = Long.toString(seconds);
    	picName = pic + ".jpg";
        
        File file = new File(Environment.getExternalStorageDirectory(), picName ); 
		outputFileUri = Uri.fromFile(file);
		intent.putExtra(MediaStore.EXTRA_OUTPUT, outputFileUri);
		startActivityForResult(intent, TAKE_PICTURE); 
    }

   

    public void btnTakePhoto(View view) {
    	Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
    	long seconds = System.currentTimeMillis() / 1000;
    	String pic = Long.toString(seconds);
    	picName = pic + ".jpg";
        
        File file = new File(Environment.getExternalStorageDirectory(), picName ); 
		outputFileUri = Uri.fromFile(file);
		intent.putExtra(MediaStore.EXTRA_OUTPUT, outputFileUri);
		startActivityForResult(intent, TAKE_PICTURE); 

		
    }
    
    //file:///mnt/sdcard/picname.jpg
    
    
    @Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
    {
		if (requestCode == TAKE_PICTURE && resultCode==RESULT_OK){
		
			 Dialog dialog = new Dialog(context);
				dialog.setContentView(R.layout.photo_dialogue);
				dialog.setTitle("Your picture has been saved");
				dialog.show();
		}
		
	}
    
}