import java.util.Scanner;
import java.text.*;

public class Learn {

	public static void main(String[] args) {
		final double exchangeRate = .74;
		String prompt = "Please enter an amount to convert from USD to EUR. Exchange rate is 1USD to .74EUR: ";

		Scanner input = new Scanner(System.in);
		System.out.print(prompt);
		String response = input.nextLine();
		try{
			if(response!=null && !response.isEmpty())
			{
				double converted = (Double.parseDouble(response))/exchangeRate;
				DecimalFormat df = new DecimalFormat("#.##");
				System.out.println(response + " USD dollars equals = "+ df.format(converted) + " EUR");
			}
			else
				System.out.println("No value entered");
		}
		catch(Exception e)
		{ 
			System.out.println("Not a valid amount");
		}
		finally{input.close();} //The finally clause is always executed regardless whether an exception occurred or not.
	}

}
