import java.text.DecimalFormat;
import java.util.Scanner;

public class FinancialPlanner 
{
	public static void main(String[] args) 
	{
		ShowWelcomeScreen();
		
		int userYearsOfSaving = GetYearsOfSaving();
		double userTargetTotal = GetTargetTotal();
		double userCurrentTotal = GetCurrentTotal();
		double userMonthlySavingsTotal = GetMonthlySavingsTotal();
		
		UserSavings.SetParameters(userYearsOfSaving, userTargetTotal, userCurrentTotal, userMonthlySavingsTotal);
		UserSavings.DisplayTotals();
	}
	
	public static void ShowWelcomeScreen() {
		System.out.println("__________________________________________________________________\n");
		System.out.println("Financial Planner App\nAaron Lieu\nOct 3, 2013\n\n\tFinancial Rules\n\tInterest Rate = 1.5%\n\tInterest is compounded monthly\n");
		System.out.println("__________________________________________________________________\n");
	}
	
	public static int GetYearsOfSaving()
	{
		System.out.print("How many years will you be saving? (example: 10)\t");
		Scanner s = new Scanner(System.in);
		int userYearsOfSaving = s.nextInt();
		
		return userYearsOfSaving;
	}
	
	public static double GetTargetTotal()
	{
		System.out.print("What is your target goal? (example: 100000.00)\t\t");
		Scanner s = new Scanner(System.in);
		double userTargetTotal = s.nextDouble();
		
		return userTargetTotal;
	}
	
	public static double GetCurrentTotal()
	{
		System.out.print("What is your current savings? (example: 5000.00)\t");
		Scanner s = new Scanner(System.in);
		double userCurrentTotal = s.nextDouble();
		
		return userCurrentTotal;
	}
	
	public static double GetMonthlySavingsTotal()
	{
		System.out.print("How much do you save every month? (example: 100.00)\t");
		Scanner s = new Scanner(System.in);
		double userMonthlySavingsTotal = s.nextDouble();
		
		return userMonthlySavingsTotal;
	}
	
	public static class UserSavings 
	{
		// Constants
		public static double interestRate = 1.5;
		public static double incrementSavingsByAmount = 0.01;
		
		// User Inputs
		public static int yearsOfSaving = 1;
		public static double targetTotal = 100000.0;
		public static double currentTotal = 10000.0;
		public static double monthlySavingsTotal = 100.0;
		
		public static void SetParameters(int userYearsOfSaving, double userTargetTotal, double userCurrentTotal, double userMonthlySavingsTotal)
		{
			yearsOfSaving = userYearsOfSaving;
			targetTotal = userTargetTotal;
			currentTotal = userCurrentTotal;
			monthlySavingsTotal = userMonthlySavingsTotal;
		}
		
		public static double CalculateTotalSavingsCompoundedMonthly()
		{
			double runningTotal = currentTotal;
			
			for (int j = 1; j <= yearsOfSaving; j++)
			{
				for (int i = 1; i <= 12; i++)
				{
					runningTotal += (runningTotal) * (interestRate / (100 * 12));
					runningTotal += monthlySavingsTotal;
				}	
			}
			
			return runningTotal;
		}
		
		public static double CalculateMinimumToReachTarget()
		{
			double initialSavingsTotal = monthlySavingsTotal;
			double calculatedSavingsTotal = 0;
			boolean targetMet = false;
			
			while (!targetMet)
			{
				monthlySavingsTotal += incrementSavingsByAmount;
				calculatedSavingsTotal = CalculateTotalSavingsCompoundedMonthly();
				
				if (calculatedSavingsTotal >= targetTotal)
				{
					targetMet = true;
				}
			}
			
			double minimumSavingsTotal = monthlySavingsTotal;
			monthlySavingsTotal = initialSavingsTotal;
			return minimumSavingsTotal;
		}
		
		public static void DisplayTotals()
		{
			boolean showColumnTwo = CalculateTotalSavingsCompoundedMonthly() >= targetTotal ? false : true;
			double runningTotal = currentTotal, runningTotal2 = currentTotal;
			double minimumMonthlySavingsTotal = CalculateMinimumToReachTarget();
			DecimalFormat formatter = new DecimalFormat("###,###,###.00");
			
			System.out.println("");
			System.out.println("");
			
			if (showColumnTwo)
			{
				System.out.println("You'll never make it at this rate, you need to save $" + formatter.format(minimumMonthlySavingsTotal - monthlySavingsTotal) + " more each month.");
				System.out.println("");
			}
			else
			{
				System.out.println("You will reach your goal of $" + formatter.format(targetTotal) + " !");
				System.out.println("");
			}
			
			System.out.println("----------------------------------------------------------------------------");
			
			if (showColumnTwo)
			{
				System.out.println("\t\t\tSaving\t\t\tSaving");
				
				if (monthlySavingsTotal < 1000.0)
				{
					System.out.println("\t\t\t($" + formatter.format(monthlySavingsTotal) + "/month)\t\t($" + formatter.format(minimumMonthlySavingsTotal) + "/month)");
				}
				else
				{
					System.out.println("\t\t\t($" + formatter.format(monthlySavingsTotal) + "/month)\t($" + formatter.format(minimumMonthlySavingsTotal) + "/month)");
				}
			}
			else
			{
				System.out.println("\t\t\tSaving");
				System.out.println("\t\t\t($" + formatter.format(monthlySavingsTotal) + "/month)");
			}
			
			System.out.println("----------------------------------------------------------------------------");
			
			for (int j = 1; j <= yearsOfSaving; j++)
			{
				for (int i = 1; i <= 12; i++)
				{
					runningTotal += ((runningTotal) * (interestRate / (100 * 12))) + monthlySavingsTotal;
					runningTotal2 += ((runningTotal2) * (interestRate / (100 * 12))) + minimumMonthlySavingsTotal;
				}	
				
				if (j < 10)
				{
					if (showColumnTwo)
					{
						if (runningTotal < 1000.0)
						{
							System.out.println("Year " + Integer.toString(j) + " Total : \t\t$" + formatter.format(runningTotal) + "\t\t\t$" + formatter.format(runningTotal2));
						}
						else 
						{
							System.out.println("Year " + Integer.toString(j) + " Total : \t\t$" + formatter.format(runningTotal) + "\t\t$" + formatter.format(runningTotal2));
						}
					}
					else
					{
						System.out.println("Year " + Integer.toString(j) + " Total : \t\t$" + formatter.format(runningTotal));
					}
				}
				else 
				{
					if (showColumnTwo)
					{
						if (runningTotal < 1000.0)
						{
							System.out.println("Year " + Integer.toString(j) + " Total : \t$" + formatter.format(runningTotal) + "\t\t\t$" + formatter.format(runningTotal2));
						}
						else
						{
							System.out.println("Year " + Integer.toString(j) + " Total : \t$" + formatter.format(runningTotal) + "\t\t$" + formatter.format(runningTotal2));
						}
					}
					else
					{
						System.out.println("Year " + Integer.toString(j) + " Total : \t$" + formatter.format(runningTotal));
					}
				}
			}
		}
	}
}
