

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;

public class SendMessageActivity extends Activity {

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	// Send a simple plain text email (no contents supplied)
	public void sendSimpleEmail(View button) {

		Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
		emailIntent.setType("plain/text");
		startActivity(emailIntent);
	}

	public void sendPlainTextEmail(View button) {

		Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);

		String aEmailList[] = { getResources()
				.getString(R.string.email_address) };
		String aEmailCCList[] = { getResources().getString(
				R.string.email_address_cc) };
		String aEmailBCCList[] = { getResources().getString(
				R.string.email_address_bcc) };

		emailIntent.putExtra(android.content.Intent.EXTRA_EMAIL, aEmailList);
		emailIntent.putExtra(android.content.Intent.EXTRA_CC, aEmailCCList);
		emailIntent.putExtra(android.content.Intent.EXTRA_BCC, aEmailBCCList);
		emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT,
				getResources().getString(R.string.email_subject));

		emailIntent.setType("plain/text");
		emailIntent.putExtra(android.content.Intent.EXTRA_TEXT, getResources()
				.getString(R.string.email_message));

		startActivity(emailIntent);
	}


	public void chooseEmail(View button) {

		Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
		emailIntent.setType("plain/text");
		startActivity(Intent.createChooser(emailIntent, getResources().getString(R.string.chooser)));

	}
}