///////////////////////////////////////////////////////////////////////////////
// autoListPage.js
// This script has specific functions used by the autoListPage.html.
///////////////////////////////////////////////////////////////////////////////

var lgInEditMode = false;
  
//
// OnLoad callback method for the page.
//
function pageOnLoad() {
  var userId = sessionStorage.getItem(gUserNameKey);
  
  getAutosByUserId(userId, dbCallback);
}

//
// Called after a successfull DB query action.
//
function dbCallback(carsArray) {
  console.log("autosLen3: " + carsArray.length);

  for (var i = 0; i < carsArray.length; i++) {
    var car = carsArray[i];
    console.log("car: " + car);
    addRowSpacer();
    addCar(car);
  }
}

//
// On click event handler for the auto selection.
//
function carOnClick(autoId) {
  console.log("carOnClick Id: " + autoId);
  
  // Session storage is used as means of communication between pages.
  sessionStorage.setItem(gSelectedAutoIdKey, autoId);
  
  // Open the auto info page.
  if (lgInEditMode == true)
    window.location.href = "autoInfoPage.html";
  else
    window.location.href = "serviceListPage.html";
}

//
// Add a spacer row to the list.
//
function addRowSpacer() {
  var carsTable = document.getElementById("myCarsTable");
  var idx = Number(carsTable.rows.length);
        
  var row = carsTable.insertRow(idx);
  row.className = "table-tr-spacer";
}

//
// Add the specified auto to the list.
//
function addCar(car) {
  var carsTable = document.getElementById("myCarsTable");
  var idx = Number(carsTable.rows.length);
        
  var row = carsTable.insertRow(idx);
  row.className = "table-tr";
  
  var cell1 = row.insertCell(0);
  cell1.className = "table-td-name";

  var subInfo = car.year + ' ' + car.make + ' ' + car.model;
  var onClickInfo = 'onclick="carOnClick(' + car.autoId + ')"'; 
  console.log(onClickInfo);

  // Add the html for the car object.    
  var content = '<div class="div-container-car" title="Select to view more information" ' + onClickInfo + '>' + 
                  '<div class="div-item">' + car.alias + '</div>' +
                  '<div class="div-subitem">' + subInfo + '</div>' +
                '</div>';
  cell1.innerHTML = content;
    
  console.log(cell1);
}

//
// Function to switch elements to reflect the mode of the
// Edit/Done modes.
//
function switchEditDoneModes(backColor, linkText, titleText, onClickFunc) {
  console.log("switchEditDoneModes()");
  
  // Change the background color for the list items.
  var x = document.getElementsByClassName("table-td-name");
  for ( var i = 0; i < x.length; i++) {
    x[i].style.backgroundColor = backColor;
    x[i].title = titleText;
  }
  
  // Change the link's text, and repoint the onClick event.
  var editLink = document.getElementById("editlink");
  editLink.innerHTML = linkText;
  editLink.onclick = onClickFunc;
}

//
// On Click handler for the Edit link.
// 
function onClickEdit() {
  console.log("onClickEdit()");
  var titleText = "Select to edit the information";

  lgInEditMode = true;
  
  // Switch the link mode from Edit to Done.
  switchEditDoneModes("cadetblue", "Done", titleText, onClickDone);
  
  // Disable the Add link.
  var addLink = document.getElementById("addlink");
  addLink.onclick = null;
  addLink.style.color = "gray";
  addLink.style.cursor = "default";
}

//
// On click handler for the Done link.
//
function onClickDone() {
  console.log("onClickDone()");
  var titleText = "Select to view more information";
  
  lgInEditMode = false;
  
  // Switch the link mode from Edit to Done.
  switchEditDoneModes("burlywood", "Edit", titleText, onClickEdit);
  
  // Enable the Add link.
  var addLink = document.getElementById("addlink");
  addLink.onclick = onClickAdd;
  addLink.style.color = "blue";
  addLink.style.cursor = "pointer";
}

//
// On Click handler for the Add link.
// 
function onClickAdd() {
  console.log("onCickAdd()");
  
  //
  // Set the selected auto id to empty, to indicate an Add New operation.
  // Session storage is used as means of communication between pages.
  //
  sessionStorage.setItem(gSelectedAutoIdKey, "");
  
  // Open the auto info page.
  window.location.href = "autoInfoPage.html";
}

