///////////////////////////////////////////////////////////////////////////////
// globals.js
// This script has global functions used by all pages.
///////////////////////////////////////////////////////////////////////////////

//
// Global variables.
//
var gUserNameKey = "autoMaintAppUserName";
var gSelectedAutoIdKey = "autoMaintSelectedAutoId";
var gDbHandleKey = "autoMaintDbHandle";
var gYesNoResult = false;
var gYesNoCallback = null;
var gInternalCall = false;

//
// Include other common scripts.
//
document.write('<script src="scripts/webSqlWrapper.js" type="text/javascript"></script>');
document.write('<script src="scripts/commonDbPrep.js" type="text/javascript"></script>');
document.write('<script src="scripts/autoInfoModel.js" type="text/javascript"></script>');
document.write('<script src="scripts/serviceRecordModel.js" type="text/javascript"></script>');
document.write('<script src="scripts/formValidation.js" type="text/javascript"></script>');

//
// OnLoad method for all pages.
//
function onLoad(pageOnLoadCallback) {
  // Prepare the auto maintenance database.
  prepareAutoDB();

  // Setup the footer for the page.
  doFooter();

  //
  // If the page wants to add a popupBox handling, then inject the
  // code into the page.
  //
  injectPopupBoxCode();

  // Call the callback function for the page.
  if (typeof pageOnLoadCallback !== 'undefined') {
    pageOnLoadCallback();
  }
}

//
// A function that displays the footer on a page.
//
function doFooter() {
  document.getElementById("footer").innerHTML = 'Auto Maintenance, Copyright 2015, Yezen Younan';
}

//
// A graceful way to get an element's value.
//
function getElementValue(elementId) {
  if (typeof elementId !== 'undefined') {
    var elem = document.getElementById(elementId);

    if (elem != null) {
      return elem.value;
    } else {
      console.log("Invalid element ID was specified: " + elementId);
      return '';
    }
  } else {
    console.log("Invalid parameter was specified.");
    return '';
  }
}

//
// A graceful way to get an element's innerHTML.
//
function getElementHTML(elementId) {
  if (typeof elementId !== 'undefined') {
    var elem = document.getElementById(elementId);

    if (elem != null) {
      return elem.innerHTML;
    } else {
      console.log("Invalid element ID was specified: " + elementId);
      return '';
    }
  } else {
    console.log("Invalid parameter was specified.");
    return '';
  }
}

//
// Return the text value of the selected Option of a Select element.
//
function getSelectElementOption(elementId) {
  if (typeof elementId !== 'undefined') {
    var elem = document.getElementById(elementId);

    if (elem != null) {
      return elem.options[elem.selectedIndex].text;
    } else {
      console.log("Invalid element ID was specified: " + elementId);
      return '';
    }
  } else {
    console.log("Invalid parameter was specified.");
    return '';
  }
}

//
// Inject popupBox code into the page, if the page wants to.
//
function injectPopupBoxCode() {
  //
  // If the page contains a DIV with id 'addPopupBox', then add
  // the popup box html.
  //
  var popupBoxPlaceholder = document.getElementById("addPopupBox");
  if (typeof popupBoxPlaceholder !== 'undefined' && popupBoxPlaceholder != null) {
    var htmlCode =
        '<div id="popupBox">' +
        '  <div id="closePopupBox">' +
        '    <a href="#" onclick="closePopupBox(); return false">X</a>' +
        '  </div>' +
        '  <div><br></div>' +
        '  <div id="popupBoxBody">' +
        '    <p id="popupBoxMsg">[no message text provided]</p>' +
        '  </div>' +
        '  <div id="popupBoxButtons" style="position: absolute; bottom: 12px; width: 95%;">' +
        '    <input type="button" id="popupYes" name="popupYes" class="buttons" value="Yes" onclick="popupYesClick();">' +
        '    <input type="button" id="popupNo" name="popupNo" class="buttons" value="No" style="float: right;" onclick="closePopupBox();">' +
        '  </div>' +
        '</div>';

    popupBoxPlaceholder.innerHTML = htmlCode;

    setPopupBoxStyles();
  }
}

//
// The popup box code was copied from the following link, with some modification.
// http://stackoverflow.com/questions/22522027/pop-up-window-with-hidden-url-address
//
function setPopupBoxStyles() {
  document.getElementById('popupBox').style.position = "absolute";
  document.getElementById('popupBoxButtons').style.display = "none";
  document.getElementById('popupBox').style.display = "none";
  document.getElementById('closePopupBox').style.display = "block";
}

// Open the popup window box.
function openPopupBox(msg) {
  // Reset variables.  gInternalCall allows us to use this method by openYesNoPopupBox
  gYesNoResult = false;
  if (gInternalCall == false)
    gYesNoCallback = null;
  gInternalCall = false;
  
  // Expand/Show the HTML code for the popup code.
  var popupMsgElement = document.getElementById('popupBoxMsg');
  if (popupMsgElement != null) 
    popupMsgElement.innerHTML = msg;
    
  document.getElementById('popupBox').style.display = "block";
  document.getElementById('grayOverlay').style.display = "block";
}

// Open the Yes/No popup window box.
function openYesNoPopupBox(msg, yesNoCallbackFunc) {
  gInternalCall = true;
  gYesNoCallback = yesNoCallbackFunc;
  
  document.getElementById('popupBoxButtons').style.display = "block";
  
  // Use the existing popup function to continue.
  openPopupBox(msg);
}

// close the popup window box.
function closePopupBox() {
  document.getElementById('popupBoxButtons').style.display = "none";
  document.getElementById('popupBox').style.display = "none";
  document.getElementById('grayOverlay').style.display = "none";

  // If the callback func was specified, then call it with Yes/No click result.  
  if (typeof gYesNoCallback !== 'undefined' && gYesNoCallback != null)
    gYesNoCallback(gYesNoResult);
}

// Handle the click on the Yes button on popup box.
function popupYesClick() {
  console.log("Yes clicked.");
  gYesNoResult = true;
  
  // All done, now close the box.
  closePopupBox();
}