///////////////////////////////////////////////////////////////////////////////
// autoInfoPage.js
// This script has functions specific to the autoInfoPage.html.
///////////////////////////////////////////////////////////////////////////////

var glEdmundsApiKey = "j9cz37rmd8wvaqrtpt7zkbb8";
var doUpdate = true;

//
// OnLoad callback method for the page.
//
function pageOnLoad() {
  document.getElementById("caralias").focus();
 
  //
  // Get the selected auto id from the session storage.
  // Session storage is used as means of communication between pages.
  //
  var selectedAutoId = sessionStorage.getItem(gSelectedAutoIdKey);
  console.log(selectedAutoId);
    
  // Enable/Disable the fields that should/should not be edited.
  doUpdate = (selectedAutoId == null || selectedAutoId.length == 0) ? false : true;
  console.log(doUpdate);
  enableFields(doUpdate);
  
  if (doUpdate == true)
    getAutoById(selectedAutoId, queryCallback);
}

//
// Handle the Car Year selection change.
// Load the list of Makes from a web api.
//
function onYearChange() {
  console.log("onYearChange()");

  // Clear the validation, if any.
  validateList('caryear');

  // Clear Makes and Models lists.
  clearSelectList('carmake');
  clearSelectList('carmodel');

  var selectedYear = getElementValue("caryear");
  var apiURL = "https://api.edmunds.com/api/vehicle/v2/makes?year=" + selectedYear + "&view=basic&fmt=json&api_key=" + glEdmundsApiKey;

  document.body.style = "cursor: wait;";

  // Load the Makes for the year.
  $.ajax({
    type: "GET",
    url: apiURL,
    dataType: "json",
    success: processMakesData,
    error: function () { alert("API call failed."); }
  });
}

//
// Callback function after Make api call.
// Add the Makes to the html list.
//
function processMakesData(data) {
  console.log("processMakesData()");
  console.log(data);

  document.body.style = "cursor: default;";

  // Add each car make to the select list.
  makeSelect = document.getElementById("carmake");
  for (var i = 0; i < data.makesCount; i++) {
    var item = data.makes[i];
    console.log(item);

    var opt = document.createElement("option");
    opt.value = item.name;
    opt.innerHTML = item.name;
    makeSelect.appendChild(opt);
  }
}

//
// Handle the Car Make selection change.
// Load the list of Models for the Make from a web api.
//
function onMakeChange() {
  console.log("onYearChange()");

  // Clear the validation, if any.
  validateList('carmake');

  // Clear Models list.
  clearSelectList('carmodel');

  var selectedYear = getElementValue("caryear");
  var selectedMake = getElementValue("carmake").toLowerCase();
  var apiURL = "https://api.edmunds.com/api/vehicle/v2/" + selectedMake +
               "/models?state=used&year=" + selectedYear +
               "&view=basic&fmt=json&api_key=" + glEdmundsApiKey;

  document.body.style = "cursor: wait;";

  // Load the Models for the make and year.
  $.ajax({
    type: "GET",
    url: apiURL,
    dataType: "json",
    success: processModelsData,
    error: function () { alert("API call failed."); }
  });
}

//
// Callback function after Model api call.
// Add the Models to the html list.
//
function processModelsData(data) {
  console.log("processModelsData()");
  console.log(data);

  document.body.style = "cursor: default;";

  // Add each car model to the select list.
  modelSelect = document.getElementById("carmodel");
  for (var i = 0; i < data.modelsCount; i++) {
    var item = data.models[i];
    console.log(item);

    var opt = document.createElement("option");
    opt.value = item.name;
    opt.innerHTML = item.name;
    modelSelect.appendChild(opt);
  }
}

//
// Handle the Car Make selection change.
//
function onModelChange() {
  // Clear the validation, if any.
  validateList('carmodel');

  // Ideally this is where we would enable the Save button.
}

//
// Clear all the options (but the first one) from the specified
// Select element.
//
function clearSelectList(elemId) {
  selElem = document.getElementById(elemId);

  // Remove all options, except for the first one.
  for (var i = selElem.options.length; i > 1; i--) {
    selElem.removeChild(selElem.options[i - 1]);
  }
}

//
// Enable/Disable the fields according to the mode of operation.
// If editing an existing auto info, then disable some of the fields
// that should not be changed.
//
function enableFields(doDisable) {
  document.getElementById("carmake").disabled = doDisable;
  document.getElementById("carmodel").disabled = doDisable;
  document.getElementById("caryear").disabled = doDisable;
  document.getElementById("removeauto").disabled = !doDisable;

  // The Alias field is always enabled and can be edited.
}

//
// Validate the input fields.
//
function validateFields() {
  var isValid = true;

  isValid &= validateInput("caralias");

  if (doUpdate == false) {
    isValid &= validateList("caryear");
    isValid &= validateList("carmake");
    isValid &= validateList("carmodel");
  }

  return isValid;
}

//
// Callback handler when the add/update operation completes.
//
function queryCallback(car) {
  console.log("queryCallback() car: " + car);

  document.getElementById("caralias").value = car.alias;

  document.getElementById("caryear").options[0].value = car.year;
  document.getElementById("caryear").options[0].innerHTML = car.year;

  document.getElementById("carmake").options[0].value = car.make;
  document.getElementById("carmake").options[0].innerHTML = car.make;

  document.getElementById("carmodel").options[0].value = car.model;
  document.getElementById("carmodel").options[0].innerHTML = car.model;
}

//
// Callback handler when the add/update operation completes.
//
function infoPageCallback() {
  console.log("infoPageCallback()");
  
  // Open the auto list page.
  window.location.href = "autoListPage.html";
}

//
// Handle the Save button click event.
//
function onClickSave() {
  if (validateFields() == false)
    return false;

  // Build the auto model object.
  var autoObj = new AutoModel();

  autoObj.alias = getElementValue("caralias");
  autoObj.year = getElementValue("caryear");
  autoObj.make = getElementValue("carmake");
  autoObj.model = getElementValue("carmodel");
  autoObj.userId = sessionStorage.getItem(gUserNameKey);

  // Update the auto if it exists, otherwise add the car to the database.
  if (doUpdate) {
    autoObj.autoId = sessionStorage.getItem(gSelectedAutoIdKey);
    updateAuto(autoObj, infoPageCallback);
  }
  else {
    addAuto(autoObj, infoPageCallback);
  }
}

//
// Handle the Back button click event.
//
function onClickBack() {
  openYesNoPopupBox("Are you sure you want to revert and go back?", yesNoCallback);
}

//
// Callback handler used by the YesNo popup, providing the btn selection result.
//
function yesNoCallback(isYes) {  
  // Open the auto list page, if confirmed.
  if (isYes == true)
    window.location.href = "autoListPage.html";
}

//
// Handle the Remove button.
//
function removeAuto() {
  openYesNoPopupBox("Are you sure you want to remove this auto?", yesNoRemoveCallback);
}

//
// Callback handler used by the YesNo popup, providing the btn selection result.
//
function yesNoRemoveCallback(isYes) {
  // If remove is confirmed, then remove the auto.
  if (isYes == true) {
    var autoId = sessionStorage.getItem(gSelectedAutoIdKey);
    deleteAuto(autoId, infoPageCallback);
  }
}

