<?php
namespace Opencart\Admin\Controller\Marketplace;
class Promotion extends \Opencart\System\Engine\Controller {
	public function index(): string {
		$this->load->language('marketplace/promotion');

		if (isset($this->request->get['type'])) {
			$type = $this->request->get['type'];
		} else {

			$pos = strrpos($this->request->get['route'], '|');

			if ($pos !== false) {
				$route = substr($this->request->get['route'], 0, $pos);
			} else {
				$route = $this->request->get['route'];
			}

			$type = substr($route, strrpos($route, '/') + 1);
		}

		$promotion = $this->cache->get('promotion.' . $type);
		
		if (!$promotion) {
			$curl = curl_init();

			curl_setopt($curl, CURLOPT_URL, 'https://3dstudiopro.com/API/json/'.$type.'.json');
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_HEADER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);

			$response = curl_exec($curl);

			curl_close($curl);

			if ($response) {
				$promotion = json_decode($response, true);
			} else {
				$promotion = '';
			}

			$this->cache->set('promotion.' . $type, $promotion, 3600 * 24);
		}

		if (isset($promotion['adsurl'])) {
			$data['banner'] 	= $promotion['banner'];
			$data['bannerurl'] 	= $promotion['adsurl'];
		} else {
			$data['banner'] 	= '';
			$data['bannerurl']	= '';
		}

		$data['extensions'] = [];

		$this->load->model('tool/image');

		if (isset($promotion['extensions'])) {
			$this->load->model('setting/extension');

			foreach ($promotion['extensions'] as $result) {
				
					$data['extensions'][] = [
						'name'     => $result['name'],
						'image'    => $result['image'],
						'href'     => $result['href']
					];
			}
		}

		return $this->load->view('marketplace/promotion', $data);
	}
}