﻿package strike.PHPRemoting {
	/* By Josh Strike // josh@joshstrike.com // Use freely and enjoy! */
		import flash.events.Event;
		import flash.events.MouseEvent;
		import flash.display.Sprite;
		import flash.display.MovieClip;
		import flash.display.Stage;
		import fl.data.DataProvider;
		import fl.controls.List;
		import flash.text.TextField;
		import flash.text.TextFormat;
		import fl.controls.UIScrollBar;
		import fl.controls.ScrollBarDirection;
		import fl.transitions.Tween;
		import fl.transitions.easing.*;
		import fl.transitions.TweenEvent;
		
		public class ResViewer {
		
		private var mainStage:Stage;
		private var pai:PHPAccess;
		private var origSW:Number;
		private var origSH:Number;
		private var tf:TextFormat;
		private var b:Sprite;
		private var bgwidth:Number;
		private var handle:Sprite;
		private var clBox:Sprite;
		private var evtList:List;
		private var stretcher:Sprite;
		private var viewer:TextField;
		private var vSB:UIScrollBar;
		private var hSB:UIScrollBar;
		private var handleDrag:Boolean;
		private var stretcherDrag:Boolean;
		private var isHidden:Boolean;
		
		public function ResViewer(pai:PHPAccess) {
			this.pai = pai;
			this.mainStage = this.pai.st;
			this.origSW = this.pai.mw;
			this.origSH = this.pai.mh;
			this.prepBox();
		}
		
		private function prepBox() {
			this.tf = new TextFormat("Courier",10);
			var wid:Number = 400;
			var hei:Number = 170;
			this.b = new Sprite();
			with (this.b.graphics) {
				lineStyle(1,0x333333,100,true);
				moveTo(0,0);
				beginFill(0x999999,70);
				lineTo(wid,0);
				lineTo(wid,hei);
				lineTo(0,hei);
				lineTo(0,0);
			}
			this.b.x = this.origSW-wid-30;
			this.b.y = 30;
			this.b.name = "bbb";
			this.bgwidth = wid;
			
			var jtxt:TextField = new TextField();
			jtxt.x = 10;
			jtxt.y = 3;
			jtxt.width = 200;
			jtxt.selectable = false;
			jtxt.text = "phpViewer ::: joshstrike.com";
			jtxt.name = "meLabel";
			jtxt.setTextFormat(this.tf);
			jtxt.textColor = 0xFFFFFF;
			this.b.addChild(jtxt);
			
			this.handle = new Sprite();
			with (this.handle.graphics) {
				moveTo(0,0);
				lineStyle(1,0x000000,100);
				beginFill(0xCCCCCC,100);
				lineTo(20,0);
				lineTo(20,20);
				lineTo(0,20);
				lineTo(0,0);
				endFill();
				moveTo(16,3);
				lineStyle(3,0xFFFFFF,100);
				lineTo(16,16);
				lineTo(3,16);
			}
			this.handle.x = wid-16;
			this.handle.y = hei-16;
			
			this.clBox = new Sprite();
			with (this.clBox.graphics) {
				moveTo(0,0);
				lineStyle(1,0x000000,100);
				beginFill(0xCCCCCC,100);
				lineTo(20,0);
				lineTo(20,20);
				lineTo(0,20);
				lineTo(0,0);
				endFill();
				lineStyle(3,0x000000,100);
				moveTo(3,10);
				lineTo(17,10);
			}
			this.clBox.x = wid-16;
			this.clBox.y = -4;
			this.clBox.addEventListener(MouseEvent.MOUSE_OVER,drawCLDark);
			this.clBox.addEventListener(MouseEvent.MOUSE_OUT,drawCLLite);
			this.clBox.addEventListener(MouseEvent.CLICK,clickCL);
			this.b.addChild(this.clBox);
			
			this.b.addEventListener(MouseEvent.MOUSE_DOWN,dragWin,false,0,true);
			this.mainStage.addEventListener(MouseEvent.MOUSE_UP,stopDragWin,false,0,true);
			this.b.addEventListener(Event.ENTER_FRAME,pushToTop,false,0,true);
			
			this.evtList = new List();
			this.evtList.setSize(200,hei-30);
			this.evtList.x = 10;
			this.evtList.y = 20;
			this.evtList.addEventListener(Event.CHANGE,listChanged);
			this.b.addChild(this.evtList);
			
			this.stretcher = new Sprite();
			with (this.stretcher.graphics) {
				moveTo(0,20);
				lineStyle(12,0x666666,100);
				lineTo(0,hei-10);
			}
			this.stretcher.x = this.evtList.x+this.evtList.width+10;
			this.b.addChild(this.stretcher);
			
			this.viewer = new TextField();
			with (this.viewer) {
				background = true;
				border = true;
				x = this.stretcher.x+10;
				y = 20;
				width = this.b.width-this.stretcher.x-30;
				height = hei-40;
				wordWrap = true;
			}
			this.b.addChild(this.viewer);

			this.vSB = new UIScrollBar();
			this.vSB.direction = ScrollBarDirection.VERTICAL;
			this.vSB.move(this.viewer.x+this.viewer.width,this.viewer.y);
			this.vSB.height = this.viewer.height;
			this.vSB.scrollTarget = this.viewer;
			this.b.addChild(this.vSB);

			this.hSB = new UIScrollBar();
			this.hSB.direction = ScrollBarDirection.HORIZONTAL;
			this.hSB.move(this.viewer.x,this.viewer.y+this.viewer.height);
			this.hSB.width = this.viewer.width;
			this.hSB.scrollTarget = this.viewer;
			this.b.addChild(this.hSB);
			
			this.drawAll();
		}
		private function drawAll() {
			this.mainStage.addChild(this.b);
			//this.b.buttonMode = true;
			this.b.addChild(this.handle);
		}
		private function dragWin(event:Object) {
			if (event.target == this.b || event.target.name == "meLabel") {
				this.b.startDrag();
			} else if (event.target == this.handle) {
				this.handleDrag = true;
				this.b.addEventListener(Event.ENTER_FRAME,resizeWin);
			} else if (event.target == this.stretcher) {
				this.stretcherDrag = true;
				this.b.addEventListener(Event.ENTER_FRAME,resizeList);
			}
		}
		private function stopDragWin(event:Object) {
			this.b.stopDrag();
			if (this.handleDrag == true) {
				this.b.removeEventListener(Event.ENTER_FRAME,resizeWin);
				this.handleDrag = false;
				this.resizeWin(this.b);
			}
			if (this.stretcherDrag == true) {
				this.b.removeEventListener(Event.ENTER_FRAME,resizeList);
				this.stretcherDrag = false;
				this.resizeList(this.b);
			}
		}
		private function resizeWin(event:Object) {
			var wid:Number = this.b.mouseX;
			var hei:Number = this.b.mouseY;			
			if (wid<400) {
				wid = 400;
			}
			this.bgwidth = wid;
			this.handle.x = wid-16;
			if (hei<170) {
				hei = 170;
			}
			this.handle.y = hei-16;
			
			this.clBox.x = wid-16;

			//this.evtList.setSize(hei-20,this.evtList.width);
			this.evtList.height = hei-30;
			
			with (this.b.graphics) {
				clear();
				lineStyle(1,0x333333,100,true);
				moveTo(0,0);
				beginFill(0x999999,70);
				lineTo(wid,0);
				lineTo(wid,hei);
				lineTo(0,hei);
				lineTo(0,0);
			}
			with (this.stretcher.graphics) {
				clear();
				lineStyle(12,0x666666,100);
				moveTo(0,20);
				lineTo(0,hei-10); 
			}
			var nvh:Number = hei-40;
			var nvw:Number = this.bgwidth-this.stretcher.x-30;
			
			this.viewer.height = nvh;
			this.viewer.width = nvw;

			this.vSB.height = nvh;
			this.vSB.x = this.viewer.x+nvw;
			this.vSB.update();
			this.hSB.width = nvw;
			this.hSB.y = this.viewer.y+nvh;
			this.hSB.update();
		}
		private function resizeList(event:Object) {
			var lw:Number = this.b.mouseX;
			if (lw<200) {
				lw = 200;
			}
			if (lw>this.b.width-170) {
				lw = this.b.width-170;
			}
			this.stretcher.x = lw;
			this.evtList.width = lw-20;
			this.viewer.x = this.stretcher.x+10;

			var nvw:Number = this.bgwidth-lw-30;			
			
			this.viewer.width = nvw;

			this.vSB.x = this.viewer.x+nvw;
			this.vSB.update();
			this.hSB.width = nvw;
			this.hSB.x = this.viewer.x;
			this.hSB.update();
		}
		public function updateBox() {
			evtList.dataProvider = new DataProvider(this.pai.record);
			if (this.evtList.selectedIndex<0) {
				this.evtList.scrollToIndex(this.evtList.dataProvider.length);
			}
		}
		private function pushToTop(event:Object) {
			//Force the viewer to the top of the Stage -- no matter what//
			if (this.mainStage.contains(b)) {
				this.mainStage.setChildIndex(this.b,this.mainStage.numChildren-1);
			}
		}
		
		private function listChanged(event:Object) {
			this.viewer.text = event.target.selectedItem.dataStr;
			this.viewer.setTextFormat(this.tf);
			this.vSB.update();
			this.hSB.update();
		}
		private function clickCL(event:Object) {
			if (!this.isHidden) {
				this.isHidden = true;
				this.mainStage.removeChild(this.b);
				this.drawCLLite(this.b);
				this.clBox.x += this.b.x;
				this.clBox.y += this.b.y;
				var clxTweenOut:Tween = new Tween(this.clBox,"x",None.easeOut,this.clBox.x,this.origSW-30,.3,true);
				var clyTweenOut:Tween = new Tween(this.clBox,"y",None.easeOut,this.clBox.y,10,.3,true);
				this.mainStage.addChild(this.clBox);
			} else {
				this.isHidden = false;
				var clxTweenIn:Tween = new Tween(this.clBox,"x",None.easeOut,this.clBox.x,this.b.x+this.b.width-16,.3,true);
				var clyTweenIn:Tween = new Tween(this.clBox,"y",None.easeOut,this.clBox.y,this.b.y-4,.3,true);
				clyTweenIn.addEventListener(TweenEvent.MOTION_FINISH,clTD);
			}
		}
		private function clTD(event:Object) {
			this.mainStage.removeChild(this.clBox);
			this.drawCLLite(this.b);
			this.clBox.x = this.b.width-16;
			this.clBox.y= -4;
			this.b.addChild(this.clBox);
			this.mainStage.addChild(this.b);
		}
		private function drawCLLite(event:Object) {
			with (this.clBox.graphics) {
				clear
				moveTo(0,0);
				lineStyle(1,0x000000,100);
				beginFill(0xCCCCCC,100);
				lineTo(20,0);
				lineTo(20,20);
				lineTo(0,20);
				lineTo(0,0);
				endFill();
				lineStyle(3,0x000000,100);
				moveTo(3,10);
				lineTo(17,10);
				if (this.isHidden) {
					moveTo(10,3);
					lineTo(10,17);
				}
			}
		}
		private function drawCLDark(event:Object) {
			with (this.clBox.graphics) {
				clear
				moveTo(0,0);
				lineStyle(1,0x000000,100);
				beginFill(0x999999,100);
				lineTo(20,0);
				lineTo(20,20);
				lineTo(0,20);
				lineTo(0,0);
				endFill();
				lineStyle(3,0x000000,100);
				moveTo(3,10);
				lineTo(17,10);
				if (this.isHidden) {
					moveTo(10,3);
					lineTo(10,17);
				}
			}
		}
		public function destroy():void {
			mainStage.contains(b) ? mainStage.removeChild(b) : mainStage.removeChild(clBox);
			b.removeEventListener(Event.ENTER_FRAME,pushToTop);
			mainStage.removeEventListener(MouseEvent.MOUSE_UP,stopDragWin);
		}
	}
}