<?php

/*empty() function checks to see if a given variable has an "empty" value.
A variable is considered to have an empty value if the variable ahs no
value, has a value of 0, or has a value of FALSE. In any of these cases,
the function returns TRUE; otherwise it returns FALSE.*/

$var1 = 0;
$var2 = 'something';
$var3 = ' '; //An empty string
echo '$var: ' . empty($var) .'<br>'; //TRUE, no defined value
echo '$var1: '.  empty($var1) .'<br>'; //TRUE, empty value
echo '$var2: ' . empty($var2) .'<br>'; //FALSE, non-empty value
echo '$var3: ' . empty($var3) .'<br>'; //TRUE, empty value

/*This function is perfect for making sure that text boxes in forms have been
filled out. For example, if you have a text input named email and the user doesn't enter
anything in it before submitting the form, then the $_POST['email'] variable will
exist but will have an empty value.*/

echo '<hr />';
/*isset function is almost the opposite of empty(). The isset() function determines whether a variable has been declared and initialized (or "set"). It returns TRUE if a variable has any value (including 0, FALSE, or an empty string). If the variable does not have a value, isset() returns FALSE.*/

$var1 = 0;
$var2 = 'something';
$var3 = ' '; //An empty string
echo '$var: ' . isset($var) .'<br>'; //FALSE, no defined value
echo '$var1: ' . isset($var1) .'<br>'; //TRUE
echo '$var2: ' . isset($var2) .'<br>'; //TRUE
echo '$var3: ' . isset($var3) .'<br>'; //TRUE

echo '<hr />';

/*is_numeric() function returns TRUE if the submitted variable has a valid numerical value and FALSE otherwise. Integers, decimals, and even strings (if they're a valid number) can all pass the is_numeric test.*/

$var1 = 2309;
$var2 = '80.23';
$var3 = '480 Nantucket Drive'; //An empty string
echo '$var1: ' . is_numeric($var1) .'<br>'; //TRUE
echo '$var2: ' . is_numeric($var2) .'<br>'; //TRUE
echo '$var3: ' . is_numeric($var3) .'<br>'; //FALSE
?>

