//
//  ClientRatings.m
//  Ratings good
//
//  Created by Peter McIntyre on 2012/11/20.
//  Copyright (c) 2012 Peter McIntyre. All rights reserved.
//

#import "ClientRatings.h"

#define BaseURL @"http://matrix.senecac.on.ca/~peter.mcintyre/"

@implementation ClientRatings

// Initialize
// The dispatch_once function will ensure that the singleton pattern is followed
+ (id)sharedInstance
{
    static ClientRatings *__sharedInstance;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        __sharedInstance = [[ClientRatings alloc] initWithBaseURL:[NSURL URLWithString:BaseURL]];
    });
    return __sharedInstance;
}

- (id)initWithBaseURL:(NSURL *)url
{
    self = [super initWithBaseURL:url];
    if (self)
    {
        // Configuration
        // e.g. can also set token header, and other settings
        [self registerHTTPOperationClass:[AFJSONRequestOperation class]];
    }
    return self;
}

@end
