//
//  Stack.m
//  calculator
//
//  Created by Antti Myllykoski on 1/20/14.
//

#import "Fifo.h"

@implementation Fifo

NSMutableArray *operands;

-(id) init {
    if( self = [super init]) {
        operands = [[NSMutableArray alloc] init];
        _count = 0;
    }
    return self;
}

-(void)queue:(NSString *) val {
    [operands addObject:val];
    _count = operands.count;
};

-(NSString *)dequeue {
    id obj = nil;
    if(operands.count > 0)
    {
        obj = [operands firstObject];
        [operands removeObjectAtIndex:0];
        _count = operands.count;
    }
    return obj;
};

-(void) queueToHead:(NSString *)val {
    [operands insertObject:val atIndex:0];
    _count = operands.count;
}

-(void)clear {
    [operands removeAllObjects];
    _count = 0;
};

@end
