//
//  ViewController.m
//  calculator
//
//  Created by Kristian Secor on 1/15/13.
//  Modified by Antti Myllykoski on 1/20/14.
//  Copyright (c) 2013 Kristian Secor. All rights reserved.
//
//  This calculator lets you enter numbers and perform arithmetic operations
//


#import "ViewController.h"
#import "Fifo.h"

@interface ViewController ()

@end

@implementation ViewController

Fifo *fifo;
bool isOperation;

NSString *const Divide = @"/";
NSString *const Add = @"+";
NSString *const Subtract = @"-";
NSString *const Multiply = @"*";

- (void)viewDidLoad
{
    [super viewDidLoad];
    _result.text = @"0";
    fifo = [[Fifo alloc] init];
    isOperation = NO;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

#pragma mark "Arithmetic operations"

- (IBAction)divide:(id)sender {
    [fifo queue:_result.text];
    [fifo queue:Divide];
    isOperation = YES;
}

- (IBAction)multiply:(id)sender {
    [fifo queue:_result.text];
    [fifo queue:Multiply];
    isOperation = YES;
}

- (IBAction)subtract:(id)sender {
    [fifo queue:_result.text];
    [fifo queue:Subtract];
    isOperation = YES;
}

- (IBAction)add:(id)sender {
    [fifo queue:_result.text];
    [fifo queue:Add];
    isOperation = YES;
}

- (IBAction)calculate:(id)sender {
    [fifo queue:_result.text];
    [self evaluate];
    isOperation = YES;
}

#pragma mark "Calculator button handlers"

- (IBAction)onZero:(id)sender {
    if ([_result.text isEqual: @"0"]  ) {
        return;
    }
    if(isOperation)
        _result.text = @"";
    _result.text = [_result.text stringByAppendingString:@"0"];
}

- (IBAction)onOne:(id)sender {
    [self append:@"1"];
}

- (IBAction)onTwo:(id)sender {
    [self append:@"2"];
}

- (IBAction)onThree:(id)sender {
    [self append:@"3"];
}

- (IBAction)onFour:(id)sender {
    [self append:@"4"];
}

- (IBAction)onFive:(id)sender {
    [self append:@"5"];
}

- (IBAction)onSix:(id)sender {
    [self append:@"6"];
}

- (IBAction)onSeven:(id)sender {
    [self append:@"7"];
}

- (IBAction)onEight:(id)sender {
    [self append:@"8"];
}

- (IBAction)onNine:(id)sender {
    [self append:@"9"];
}

- (IBAction)onClear:(id)sender {
    _result.text = @"";
    [fifo clear];
}

-(void) append:(NSString *) num {
    if ([_result.text  isEqual: @"0"] || isOperation ) {
        _result.text = @"";
        isOperation = NO;
    }
    _result.text = [_result.text stringByAppendingString:num];
}

#pragma mark "The calculator engine"

- (void)crunchNumbers:(int)operand2 operand1:(int)operand1 operation:(NSString *)operation {
    if([operation isEqualToString:Divide]) {
        if(operand2 == 0) {
            _result.text = @"Division by zero!";
            [fifo clear];
            return;
        }
        else {
            [fifo queueToHead:[NSString stringWithFormat:@"%i", operand1 / operand2]];
        }
    } else if([operation isEqualToString:Add]) {
        [fifo queueToHead:[NSString stringWithFormat:@"%i", operand1 + operand2]];
    } else if([operation isEqualToString:Subtract]) {
        [fifo queueToHead:[NSString stringWithFormat:@"%i", operand1 - operand2]];
    } else {
        [fifo queueToHead:[NSString stringWithFormat:@"%i", operand1 * operand2]];
    }
}

-(void) evaluate {
    int operand1, operand2;
    NSString *operation;
    
    while (fifo.count > 1) {
        operand1 = [[fifo dequeue] intValue];
        operation = [fifo dequeue];
        operand2 = [[fifo dequeue] intValue];
        
        NSLog(@"%i, %@, %i", operand1, operation, operand2 );
        [self crunchNumbers:operand2 operand1:operand1 operation:operation];
    }
    _result.text = [fifo dequeue];
}

@end
