//
//  sssViewController.m
//  Location
//
//  Created by Sora Sung on 1/28/14.
//  Copyright (c) 2014 Sora Sung. All rights reserved.
//

#import "sssViewController.h"

@interface sssViewController ()

@end

@implementation sssViewController

NSString* locationName;
int locId = 1;
NSMutableArray* latLong;

- (void)viewDidLoad
{
    [super viewDidLoad];
    [[LocationHandler getSharedInstance]setDelegate:self];
    [[LocationHandler getSharedInstance]startUpdating];
    
    [self copyPlist];
}

- (void) copyPlist {
    NSError *error;
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory =  [paths objectAtIndex:0];
    NSString *path = [documentsDirectory stringByAppendingPathComponent:@"Data.plist"];
    NSFileManager *fileManager = [NSFileManager defaultManager];
    
    if ( ![fileManager fileExistsAtPath:path] ) {
        NSLog(@"copying database to users documents");
        NSString *pathToSettingsInBundle = [[NSBundle mainBundle] pathForResource:@"Data" ofType:@"plist"];
        [fileManager copyItemAtPath:pathToSettingsInBundle toPath:path error:&error];
    }
    else {
        NSLog(@"users database already configured");
    }
}

-(void)loadPList
{
    // Data.plist code
	// get paths from root direcory
	NSArray *paths = NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES);
	// get documents path
	NSString *documentsPath = [paths objectAtIndex:0];
	// get the path to our Data/plist file
	NSString *plistPath = [documentsPath stringByAppendingPathComponent:@"Data.plist"];
	
	// check to see if Data.plist exists in documents
	if (![[NSFileManager defaultManager] fileExistsAtPath:plistPath])
	{
		// if not in documents, get property list from main bundle
		plistPath = [[NSBundle mainBundle] pathForResource:@"Data" ofType:@"plist"];
	}
	
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(void)didUpdateToLocation:(CLLocation *)newLocation fromLocation:(CLLocation *)oldLocation{
    [_latitude setText:[NSString stringWithFormat:
                            @"Latitude: %f",newLocation.coordinate.latitude]];
    [_longitude setText:[NSString stringWithFormat:
                             @"Longitude: %f",newLocation.coordinate.longitude]];
}

- (IBAction)saveData:(id)sender {
    
    // get paths from root direcory
	NSArray *paths = NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES);
	// get documents path
	NSString *documentsPath = [paths objectAtIndex:0];
	// get the path to our Data/plist file
	NSString *plistPath = [documentsPath stringByAppendingPathComponent:@"Data.plist"];
    
    NSString *coordinates = [NSString stringWithFormat:@"%@,%@", _latitude.text, _longitude.text];
    
    //add name for this array
    locationName = [NSString stringWithFormat:@"%i",locId];
    locationName= [locationName stringByAppendingString:@" Latitude_Longitude"];
    locId++;
    
    //check if the plist file exists
    NSFileManager *fileManager = [NSFileManager defaultManager];
    NSLog(@"Got fileManager, checking if pListPath exists at: %@", plistPath);
    if ([fileManager fileExistsAtPath:plistPath] ) {
        
    NSMutableArray *pContent = [NSMutableArray arrayWithContentsOfFile:plistPath];
        if (pContent == nil) pContent = [NSMutableArray array];
        [pContent addObject:coordinates];
        [pContent writeToFile:plistPath atomically:YES];
        _label.text = [@"Save data - " stringByAppendingString:_latitude.text];
        
    }
    else
	{
        NSLog(@"Error in saveData");
        _label.text = @"Unable to save data";
    }
}


@end
