//
//  MapsViewController.m
//  Maps
//
//  Created by Kristian Secor on 2/4/14.
//  Copyright (c) 2014 Kristian Secor. All rights reserved.
//

#import "MapsViewController.h"
#import "MapAnnotation.h"
@interface MapsViewController()

@end

@implementation MapsViewController



#define METERS_PER_MILE 1609.344

- (void)viewDidLoad
{
    [super viewDidLoad];
    mapView = [[MKMapView alloc]initWithFrame:
               CGRectMake(10, 20, 300, 300)];
    mapView.delegate = self;
    mapView.centerCoordinate = CLLocationCoordinate2DMake(37.32, -122.03);
    mapView.mapType = MKMapTypeHybrid;
    CLLocationCoordinate2D location;
    
    location.latitude = (double) 37.332768;
    location.longitude = (double) -122.030039;
  //Add the annotation to our map view
    MapAnnotation *newAnnotation = [[MapAnnotation alloc]
                                    initWithTitle:@"Apple Head quarters" andCoordinate:location];
[mapView addAnnotation:newAnnotation];
    CLLocationCoordinate2D location2;
    location2.latitude = (double) 37.33039;
    location2.longitude = (double) -122.034919;
    MapAnnotation *newAnnotation2 = [[MapAnnotation alloc]
                                     initWithTitle:@"Test annotation" andCoordinate:location2];
[mapView addAnnotation:newAnnotation2];
    [self.view addSubview:mapView];
}





- (void)mapView:(MKMapView *)mv didAddAnnotationViews:(NSArray *)views
{
    MKAnnotationView *annotationView = [views objectAtIndex:0];
    id <MKAnnotation> mp = [annotationView annotation];
    MKCoordinateRegion region = MKCoordinateRegionMakeWithDistance
    ([mp coordinate], 5*METERS_PER_MILE, 5*METERS_PER_MILE);

    
    [mv setRegion:region animated:YES];
    [mv selectAnnotation:mp animated:YES];
}





- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
