//
//  CameraViewController.h
//  Database
//
//  Created by Kristian Secor on 2/8/14.
//  Copyright (c) 2014 Neil Smyth. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <MobileCoreServices/MobileCoreServices.h>

@class CameraViewController;

@protocol CameraViewControllerDelegate <NSObject>
- (void)addPictureViewController:(CameraViewController *)controller didFinishEnteringItem:(UIImage *)item;
@end

@interface CameraViewController : UIViewController <UIImagePickerControllerDelegate,
UINavigationControllerDelegate>

@property (strong, nonatomic) IBOutlet UIImageView *imageView;
@property (nonatomic, weak) id <CameraViewControllerDelegate> delegate;

@property BOOL newPic;
- (IBAction)useCamera:(id)sender;

- (IBAction)useCameraRoll:(id)sender;


@end
