//
//  CameraViewController.m
//  Database
//
//  Created by Kristian Secor on 2/8/14.
//  Copyright (c) 2014 Neil Smyth. All rights reserved.
//

#import "CameraViewController.h"

@interface CameraViewController ()

@end

@implementation CameraViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
	// Do any additional setup after loading the view.
}


- (IBAction)useCameraRoll:(id)sender {
  //  NSLog(@"%s",__FUNCTION__);
if ([UIImagePickerController isSourceTypeAvailable:
         UIImagePickerControllerSourceTypeSavedPhotosAlbum])
    {
        UIImagePickerController *imagePicker =
        [[UIImagePickerController alloc] init];
        imagePicker.delegate = self;
        imagePicker.sourceType =
        UIImagePickerControllerSourceTypePhotoLibrary;
        imagePicker.mediaTypes = @[(NSString *) kUTTypeImage];
        imagePicker.allowsEditing = NO;
        [self presentViewController:imagePicker
        animated:YES completion:nil];
        _newPic = NO;
        
        
    }
}

#pragma mark -
#pragma mark UIImagePickerControllerDelegate

-(void)imagePickerController:(UIImagePickerController *)picker
didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    NSString *mediaType = info[UIImagePickerControllerMediaType];
    
    [self dismissViewControllerAnimated:YES completion:nil];
    
    if ([mediaType isEqualToString:(NSString *)kUTTypeImage]) {
        UIImage *image = info[UIImagePickerControllerOriginalImage];
        _imageView.image = image;
        if (_newPic)
            UIImageWriteToSavedPhotosAlbum(image,
                                           self,
                                           @selector(image:finishedSavingWithError:contextInfo:),
                                           nil);
        NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
        NSString *documentsDirectory = [paths objectAtIndex:0];
        /*
        NSData *imageData = UIImageJPEGRepresentation(YourImage, 1.0);
        NSString *path = NSDocumentDirectory();
        NSString *tmpPathToFile = [[NSString alloc] initWithString:[NSString stringWithFormat:@"%@/%@.jpg", path, specificImagedNameTakenFromUser]];
        
        if([imageData writeToFile:tmpPathToFile atomically:YES]){
            //Write was successful. 
        }
         */
        
       NSString *appendPic = [NSString stringWithFormat:@"%@.png",_idForPic];
        NSData *pngData = UIImagePNGRepresentation(image);
        NSString *documentsPath = [paths objectAtIndex:0]; //Get the docs directory
        NSString * filePath = [documentsPath stringByAppendingPathComponent:appendPic]; //Add the file name
        if ([pngData writeToFile:filePath atomically:YES]){
            NSLog(@"Success");
        }
        else{
            NSLog(@"Fail");
            
        }
        
        
        /*
        
        //  NSString *imagePath = [documentsDirectory stringByAppendingPathComponent:appendPic];
        
        UIImage *pickedImage = [info objectForKey:UIImagePickerControllerEditedImage];
        NSData *data=UIImagePNGRepresentation(pickedImage);
        
         NSString *tmpPathToFile = [[NSString alloc] initWithString:[NSString stringWithFormat:@"%@/%@",documentsDirectory,appendPic]];
       
        if([data writeToFile:tmpPathToFile atomically:YES]){
          NSLog(@"Success");
        }
        else{
            NSLog(@"Fail");

        }
         */
    }

        /*
         gets the original pic name
        NSURL *refURL = [info valueForKey:UIImagePickerControllerReferenceURL];
        
        // define the block to call when we get the asset based on the url (below)
        ALAssetsLibraryAssetForURLResultBlock resultblock = ^(ALAsset *imageAsset)
        {
            ALAssetRepresentation *imageRep = [imageAsset defaultRepresentation];
            NSLog(@"[imageRep filename] : %@", [imageRep filename]);
        };
        
        // get the asset library and fetch the asset based on the ref url (pass in block above)
        ALAssetsLibrary* assetslibrary = [[ALAssetsLibrary alloc] init];
        [assetslibrary assetForURL:refURL resultBlock:resultblock failureBlock:nil];
         */

}

    -(void)image:(UIImage *)image
finishedSavingWithError:(NSError *)error
contextInfo:(void *)contextInfo
    {
        if (error) {
            UIAlertView *alert = [[UIAlertView alloc]
                                  initWithTitle: @"Save failed"
                                  message: @"Failed to save image"
                                  delegate: nil
                                  cancelButtonTitle:@"OK"
                                  otherButtonTitles:nil];
            [alert show];
        }
    }
    
    

-(void)imagePickerControllerDidCancel:(UIImagePickerController *)picker
{
    [self dismissViewControllerAnimated:YES completion:nil];
}




- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)useCamera:(id)sender {
}


@end
