#import <Foundation/Foundation.h>

int main (int argc, const char * argv[])
{
    
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
    // create a mutable dictionary
    NSMutableDictionary *states =
    [NSMutableDictionary dictionaryWithObjectsAndKeys:
     @"Arizona",@"AZ",
     @"California",@"CA",
     @"Colorado",@"CO",
     @"Hawaii",@"HI",
     @"New Mexico",@"NM",
     nil];
    // add to it
    [states setObject:@"Florida" forKey:@"FL"];
    
    for (NSString *stateAbbrev in states) {
    //    NSLog(@"  %@ is for %@", stateAbbrev, [states objectForKey:stateAbbrev]);
    }
    //why is it out of order?
   // Dictionary is hash mapped for faster retrieval. You are not allowed to fix its order.
    
    NSArray * values = [states allValues];
    NSLog(@"This is my NSArray: %@", [values description]);
    
    
    
    //from https://developer.apple.com/library/mac/documentation/Cocoa/Conceptual/Collections/Articles/Arrays.html#//apple_ref/doc/uid/20000132-SW5
    //First create the array of dictionaries
    NSString *last = @"lastName";
    NSString *first = @"firstName";
    
    NSMutableArray *array = [NSMutableArray array];
    NSArray *sortedArray;
    
    NSDictionary *dict;
    dict = [NSDictionary dictionaryWithObjectsAndKeys:
            @"Jo", first, @"Smith", last, nil];
    [array addObject:dict];
    
    dict = [NSDictionary dictionaryWithObjectsAndKeys:
            @"Joe", first, @"Smith", last, nil];
    [array addObject:dict];
    
    dict = [NSDictionary dictionaryWithObjectsAndKeys:
            @"Joe", first, @"Smythe", last, nil];
    [array addObject:dict];
    
    dict = [NSDictionary dictionaryWithObjectsAndKeys:
            @"Joanne", first, @"Smith", last, nil];
    [array addObject:dict];
    
    dict = [NSDictionary dictionaryWithObjectsAndKeys:
            @"Robert", first, @"Jones", last, nil];
    [array addObject:dict];
    
    //Next we sort the contents of the array by last name then first name
    
    // The results are likely to be shown to a user
    // Note the use of the localizedCaseInsensitiveCompare: selector
    NSSortDescriptor *lastDescriptor =
    [[NSSortDescriptor alloc] initWithKey:last
                                ascending:YES
                                 selector:@selector(localizedCaseInsensitiveCompare:)];
    NSSortDescriptor *firstDescriptor =
    [[NSSortDescriptor alloc] initWithKey:first
                                ascending:YES
                                 selector:@selector(localizedCaseInsensitiveCompare:)];
    
    NSArray *descriptors = [NSArray arrayWithObjects:lastDescriptor, firstDescriptor, nil];
    sortedArray = [array sortedArrayUsingDescriptors:descriptors];


    NSLog(@"This is my NSArray: %@", [sortedArray description]);

    

}
