//
//  GameBoardViewController.m
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 2/15/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "GameBoardViewController.h"

@interface GameBoardViewController () {

    NSDate *baseDate;
    NSTimer *gameTime;

}

@end


@implementation GameBoardViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}
-(void)viewWillDisappear:(BOOL)animated {
    if (!self.currentGame.endDate) {
        [self pauseOrResumeGameTimer];
    }
    
    
}

-(void)viewWillAppear:(BOOL)animated
{
    
    
    NSLog(@"1.- selected Item: %@", self.selectedTS);
    if (self.selectedTS.hasBeenUpdated) {
//        NSLog(@"2.- selected Item: %@", self.selectedTS);
//        [self.tSigns removeObjectAtIndex:self.selectedTS.position];
//        NSLog(@"3.- selected Item: %@", self.selectedTS);
//        [self.tSigns insertObject:self.selectedTS atIndex:self.selectedTS.position];
        
        GameDetailsDAO *dao = [[GameDetailsDAO alloc]init];
        [dao updateGameDetails:self.selectedTS];
        dao = Nil;
        
        [self.collectionView reloadData];
        self.selectedTS.hasBeenUpdated = NO;
    }
    
    if ([self calculateBingo]) {
        //NSLog(@"\nBINGO!!!!");
        
        if (!self.currentGame.endDate) {
            self.currentGame.endDate = [NSDate date];
            self.currentGame.gotBingo = YES;
            [self pauseOrResumeGameTimer];
            
            RTBGameDAO *dao = [[RTBGameDAO alloc]init];
            [dao saveCurrentGame:self.currentGame];
            dao = Nil;            
            
            UIAlertView *bingoAlert = [[UIAlertView alloc]
                                       initWithTitle:@"Congratulations!" message:@"You've got BINGO!!" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
            [bingoAlert show];
        }
        
    }
    if (!self.currentGame.endDate) {
        [self pauseOrResumeGameTimer];
    }
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.playerNameLabel.text = self.currentGame.playerName;
    baseDate = self.currentGame.startDate;
    
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return [self.tSigns count];
}

// The cell that is returned must be retrieved from a call to -dequeueReusableCellWithReuseIdentifier:forIndexPath:
- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
    TrafficSignCell *tsCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"tsCell" forIndexPath:indexPath];
    
    RTBSign *gts = [self.tSigns objectAtIndex:indexPath.row];
    
    tsCell.tsCellImage.image = [UIImage imageNamed:gts.defaultImageUrl];
    
    if (gts.timestamp) {
        tsCell.tsCellImage.alpha = 1;
    }
    else {
        tsCell.tsCellImage.alpha = 0.5;
    }
    return tsCell;
}


- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - protocol methods
- (void) passTSToGameBoardViewController:(TSDetailsViewController *)controller didFinishEditingTS:(RTBSign *)selectedItem
{
//    self.selectedTS = selectedItem;
//    self.selectedTSindex = selectedItemIndex;
//    NSLog(@"selected item index: %i, with value: %@", selectedItemIndex, selectedItem);
    
    self.selectedTS = selectedItem;
   // NSLog(@"Passed ITEM: index: %i, with value: %@", selectedItem.position, selectedItem.name);
}

#pragma mark - Navigation
-(void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {

    if([segue.identifier isEqualToString:@"showSignDetail"]){
        TSDetailsViewController *tsdvc = [segue destinationViewController];
        
        NSIndexPath *selectedIndexPath = [[self.collectionView indexPathsForSelectedItems] objectAtIndex:0];
        //NSLog(@"Index: %li", (long)selectedIndexPath.row);
        tsdvc.detailedTS = [self.tSigns objectAtIndex:selectedIndexPath.row];
        tsdvc.detailedTS.hasBeenUpdated = NO;
        tsdvc.currentGame = self.currentGame;
        
        tsdvc.delegate = self;
    }
}

#pragma mark - User methods
-(BOOL) calculateBingo {
    //matrix size
    int mSize = 5;
    
    //counters arrays for checked cells on each row, each column, main diagonal and reverse diagonal
    int row [mSize], column [mSize], diag1 = 0, diag2 = 0;
    
    //counters for each row or column in the counters
    int r=0, c=0, totalHits=0;
    
    BOOL bingo = FALSE;
    
    //initialization of counter arrays
    for (int i = 0; i < mSize; i++) {
        row[i] = 0;
        column[i] = 0;
    }
    
    //object retrieved at each cell of the array of signs
    RTBSign *gts = [[RTBSign alloc]init];
    
    //Loop through the array of signs
    for (int i=0; i<25; i++){
        
        //if the index in the main array is multiple of the matrix dimension we should increment rows
        //and reset the column, except for i = 0
        if (i!=0 && i % (mSize) == 0) {
            r++;
            c=0;
        }
        
        gts = [self.tSigns objectAtIndex:i];
    
        if (gts.timestamp) {
            
            //if the sign has been checked, increment the score in row and column
            row [r]++;
            column [c]++;
            totalHits++;
            
            // if row and column are the same, increment the score in main diagonal
            if (r==c) {
                diag1++;
            }
            
            //The row and column for each cell in the reverse diagonal will sum the matrix dimension
            if (r + c == mSize-1) {
                diag2++;
            }
        }
        
        
        //each loop should increment the column to be checked
        c++;
    }
    
    //Check rows and columns to see if the user has got a Bingo!
    for (int i=0; i<mSize; i++) {
        //NSLog(@"\nRow [%i] = %i\nColumn [%i] = %i\n", i, row[i], i, column[i]);
        if (row[i] == mSize || column[i] == mSize)  {
            bingo = TRUE;
        }
    }
    
    if (diag1 == mSize || diag2 == mSize) {
        bingo = TRUE;
    }
    
    //NSLog(@"\nmain Diag:%i\nReverseDiag=%i", diag1, diag2);
    
    int maxRow=0, maxColumn=0;
    
    maxRow = maxValueOfArray(row, mSize);
    maxColumn = maxValueOfArray(column, mSize);
    //NSLog(@"maxRow = %d\nmaxColumn=%d\ndiag1=%i\ndiag2=%i\n", maxRow, maxColumn, diag1, diag2);
    
    self.lineLabel.text = [NSString stringWithFormat:@"Line:\t%d", MAX(maxColumn, MAX(maxRow, MAX(diag1, diag2)))];
    self.totalLabel.text = [NSString stringWithFormat:@"Total:\t%d", totalHits];
    
    
    return bingo;

}

-(void)pauseOrResumeGameTimer {
    
    if (!gameTime) {
        gameTime = [NSTimer scheduledTimerWithTimeInterval:.1
                                                    target:self
                                                    selector:@selector(updateTimerLabel)
                                                    userInfo:Nil
                                                    repeats:YES];
    }
    else {
        [gameTime invalidate];
        gameTime = nil;
    }
}

//Method to display a time counter label in the game
-(void)updateTimerLabel {
    NSTimeInterval interval;
    if (self.currentGame.endDate) {
        interval = [self.currentGame.endDate timeIntervalSinceDate:baseDate];
    }else {
        interval = [baseDate timeIntervalSinceNow];
    }
    //double intpart;
    //double fractional = modf(interval, &intpart);
    //NSUInteger hundredth = ABS((int)(fractional*100));
    NSUInteger seconds = ABS((int)interval);
    NSUInteger minutes = seconds/60;
    NSUInteger hours = minutes/60;
//    self.gameTimerLabel.text = [NSString stringWithFormat:@"%02d:%02d:%02d:%02d", hours, minutes%60, seconds%60, hundredth];
    self.gameTimerLabel.text = [NSString stringWithFormat:@"%02lu:%02lu:%02lu", (unsigned long)hours, minutes%60, seconds%60];
}


- (IBAction)backButton:(id)sender {
    [[self navigationController] popViewControllerAnimated:YES];    
}
@end



int maxValueOfArray(int myArray[], size_t size) {
    /* enforce the contract */
    //assert(myArray && size);
    
    //By definition, the size of an array cannot be negative. The appropriate variable for array sizes in C is size_t
    size_t i;
    int maxValue = myArray[0];
    
    NSLog(@"maxValue = %d\nsize=%zu",maxValue, size);
    
    for (i = 1; i < size; ++i) {
        if ( myArray[i] > maxValue ) {
            maxValue = myArray[i];
        }
    }
    return maxValue;
}
