<?php 

//Put XML Contents Into Array (PHP.net Function)
function xml2assoc($xml) { 
    $tree = null; 
    while($xml->read()) 
        switch ($xml->nodeType) { 
            case XMLReader::END_ELEMENT: return $tree; 
            case XMLReader::ELEMENT: 
                $node = array('tag' => $xml->name, 'value' => $xml->isEmptyElement ? '' : xml2assoc($xml)); 
                if($xml->hasAttributes) 
                    while($xml->moveToNextAttribute()) 
                        $node['attributes'][$xml->name] = $xml->value; 
                $tree[] = $node; 
            break; 
            case XMLReader::TEXT: 
            case XMLReader::CDATA: 
                $tree .= $xml->value; 
        } 
    return $tree; 
} 

//Open XML Reading Object
$xml = new XMLReader(); 
//Open X<L FIle
$xml->open('http://twitter.com/statuses/user_timeline/188578770.xml');
//Put Document in Arrays
$assoc = xml2assoc($xml);
//Close XML Object
$xml->close(); 
//Store Result
$lastTweet = $assoc[0]['value'][0]['value'][2]['value'];