//
//  PictureListDetail.m
//  savePictures
//
//  Created by Kristian Secor on 2/13/13.
//  Copyright (c) 2013 Kristian Secor. All rights reserved.
//
#import "PictureListDetail.h"
#import "BigPic.h"

@implementation PictureListDetail

@synthesize managedObjectContext;
@synthesize currentPicture;
@synthesize titleField, descriptionField, imageField;
@synthesize imagePicker;

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // If we are editing an existing picture, then put the details from Core Data into the text fields for displaying
    NSLog(@"current picture is %@",currentPicture);
    if (currentPicture)
    {
        [titleField setText:[currentPicture title]];
        [descriptionField setText:[currentPicture desc]];
        if ([currentPicture smallPicture])
            [imageField setImage:[UIImage imageWithData:[currentPicture smallPicture]]];
    }
}

#pragma mark - Button actions

- (IBAction)editSaveButtonPressed:(id)sender
{
    // If we are adding a new picture (because we didnt pass one from the table) then create an entry
    if (!currentPicture)
        self.currentPicture = (Pictures *)[NSEntityDescription insertNewObjectForEntityForName:@"Pictures" inManagedObjectContext:self.managedObjectContext];
    
    // For both new and existing pictures, fill in the details from the form
    [self.currentPicture setTitle:[titleField text]];
    [self.currentPicture setDesc:[descriptionField text]];
    
    if (imageField.image)
    {
        // Resize and save a smaller version for the table
        float actualWidth = imageField.image.size.width;
        float actualHeight = imageField.image.size.height;
        float newWidth, newHeight, ratio;
        
        float max_height = 320;
        float max_width = 320;
        
        
        float width_ratio  = (actualWidth / max_width);
        float height_ratio = (actualHeight / max_height);
        
        if(width_ratio >=height_ratio)
        {
            ratio = width_ratio;
        }
        else
        {
            ratio = height_ratio;
        }
        
        newWidth    =  actualWidth / ratio;
        newHeight   = (actualHeight / ratio);
        
        CGRect rect = CGRectMake(0.0, 0.0, newWidth, newHeight);
        UIGraphicsBeginImageContext(rect.size);
        [imageField.image drawInRect:rect];
        UIImage *smallImage = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        
        // Save the small image version
        NSData *smallImageData = UIImageJPEGRepresentation(smallImage, 1.0);
        [self.currentPicture setSmallPicture:smallImageData];
        
    }
    
    //  Commit item to core data
    NSError *error;
    if (![self.managedObjectContext save:&error])
        NSLog(@"Failed to add new picture with error: %@", [error domain]);
    
    //  Automatically pop to previous view now we're done adding
    [self.navigationController popViewControllerAnimated:YES];
}

//  Pick an image from album
- (IBAction)imageFromAlbum:(id)sender
{
    imagePicker = [[UIImagePickerController alloc] init];
    imagePicker.delegate = self;
    imagePicker.sourceType = UIImagePickerControllerSourceTypeSavedPhotosAlbum;
    [self presentViewController:imagePicker animated:YES completion:nil];
}

//  Take an image with camera
- (IBAction)imageFromCamera:(id)sender
{
    imagePicker = [[UIImagePickerController alloc] init];
    imagePicker.delegate = self;
    imagePicker.sourceType = UIImagePickerControllerSourceTypeCamera;
    imagePicker.cameraDevice = UIImagePickerControllerCameraDeviceRear;
    [self presentViewController:imagePicker animated:YES completion:nil];
}

//  Resign the keyboard after Done is pressed when editing text fields
- (IBAction)resignKeyboard:(id)sender
{
    [sender resignFirstResponder];
}

#pragma mark - Image Picker Delegate Methods

//  Dismiss the image picker on selection and use the resulting image in our ImageView
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingImage:(UIImage *)image editingInfo:(NSDictionary *)editingInfo
{
    [imagePicker dismissModalViewControllerAnimated:YES];
    [imageField setImage:image];
}

//  On cancel, only dismiss the picker controller
- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker
{
     [[imagePicker presentingViewController] dismissViewControllerAnimated:YES completion:nil];
}


-(void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    BigPic *bigpicdetail = (BigPic *)[segue destinationViewController];
    bigpicdetail.managedObjectContext = managedObjectContext;
    bigpicdetail.bigPicture = currentPicture;
}

@end