//
//  PlistTutorialViewController.m
//  PlistTutorial
//
//  Created by Kent Franks on 5/27/11.
//  Copyright 2011 TheAppCodeBlog. All rights reserved.
//

#import "PlistTutorialViewController.h"

@implementation PlistTutorialViewController

@synthesize personName;
@synthesize phoneNumbers;
@synthesize nameEntered, homePhone, workPhone, cellPhone;

- (void)viewDidLoad 
{
    [super viewDidLoad];
	// Data.plist code
	// get paths from root direcory
	NSArray *paths = NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES);
	// get documents path
	NSString *documentsPath = [paths objectAtIndex:0];
	// get the path to our Data/plist file
	NSString *plistPath = [documentsPath stringByAppendingPathComponent:@"Data.plist"];
	
	// check to see if Data.plist exists in documents
	if (![[NSFileManager defaultManager] fileExistsAtPath:plistPath]) 
	{
		// if not in documents, get property list from main bundle
		plistPath = [[NSBundle mainBundle] pathForResource:@"Data" ofType:@"plist"];
	}
	
	// read property list into memory as an NSData object
	NSData *plistXML = [[NSFileManager defaultManager] contentsAtPath:plistPath];
	NSString *errorDesc = nil;
	NSPropertyListFormat format;
	// convert static property liost into dictionary object
	NSDictionary *temp = (NSDictionary *)[NSPropertyListSerialization propertyListFromData:plistXML mutabilityOption:NSPropertyListMutableContainersAndLeaves format:&format errorDescription:&errorDesc];
	if (!temp) 
	{
		NSLog(@"Error reading plist: %@, format: %d", errorDesc, format);
	}
	// assign values
	self.personName = [temp objectForKey:@"Name"];
	self.phoneNumbers = [NSMutableArray arrayWithArray:[temp objectForKey:@"Phones"]];
	// display values
    //personName
    //phonenumbers
    
	nameEntered.text = personName;
	homePhone.text = [phoneNumbers objectAtIndex:0];
	workPhone.text = [phoneNumbers objectAtIndex:1];
	cellPhone.text = [phoneNumbers objectAtIndex:2];
}

- (IBAction) saveData
{
	// get paths from root direcory
	NSArray *paths = NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES);
	// get documents path
	NSString *documentsPath = [paths objectAtIndex:0];
	// get the path to our Data/plist file
	NSString *plistPath = [documentsPath stringByAppendingPathComponent:@"Data.plist"];
	
	// set the variables to the values in the text fields
	self.personName = nameEntered.text;
	self.phoneNumbers = [[NSMutableArray alloc] initWithCapacity:3];
	[phoneNumbers addObject:homePhone.text];
	[phoneNumbers addObject:workPhone.text];
	[phoneNumbers addObject:cellPhone.text];
	
    
    
    
	
	// create dictionary with values in UITextFields
    NSDictionary *plistDict = [NSDictionary dictionaryWithObjects: [NSArray arrayWithObjects: personName, phoneNumbers, nil] forKeys:[NSArray arrayWithObjects: @"Name", @"Phones", nil]];
    
    
    //So for the homework, you will append the above data to the the plist Dictionary below
	
	NSString *error = nil;
	// create NSData from dictionary
    NSData *plistData = [NSPropertyListSerialization dataFromPropertyList:plistDict format:NSPropertyListXMLFormat_v1_0 errorDescription:&error];
	
    // check is plistData exists
	if(plistData) 
	{
		// write plistData to our Data.plist file
        [plistData writeToFile:plistPath atomically:YES];
        
        
    }
    else 
	{
        NSLog(@"Error in saveData: %@", error);
        [error release];
    }
}

// we use this to dismiss the keyboard when the return key is pressed
- (IBAction) textFieldReturn:(id)textField
{
	[textField resignFirstResponder];
}


- (void)dealloc 
{
    [super dealloc];
}

@end
