//
//  UIImage+Thumbnail.m
//  WorkingWithImages
//
//  Created by Juan Navas Martin on 2/19/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "UIImage+Thumbnail.h"

@implementation UIImage (Thumbnail)

- (UIImage *)createThumbnail: (UIImage*)image withSize:(CGSize)size {
    
    CGSize originalSize = image.size;
    CGSize croppedSize;
    
    CGFloat wRatio = size.width / originalSize.width ;
    CGFloat hRatio = size.height / originalSize.height;
    
    CGFloat ratio = MIN(wRatio, hRatio);
    
    croppedSize.height = originalSize.height * ratio;
    croppedSize.width = originalSize.width * ratio;
    
    CGRect rect = CGRectMake(0, 0, croppedSize.width, croppedSize.height);
    
    UIGraphicsBeginImageContext(rect.size);

    [image drawInRect:rect];
    UIImage *thumbnail = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    return thumbnail;
    
}

@end
