//
//  GameTrafficSign.h
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 2/21/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface RTBSign : NSObject

@property (nonatomic) int gameID;
@property (nonatomic) int position;
@property (strong, nonatomic) NSString *name;
@property (strong, nonatomic) NSString *defaultImageUrl;
@property (strong, nonatomic) NSString *userImageUrl;
@property (strong, nonatomic) NSDate *timestamp;
@property (nonatomic) float latitude;
@property (nonatomic) float longitude;
@property (nonatomic) BOOL hasBeenUpdated;

//Designated initializer
-(id) initWithName:(NSString *)name andPosition:(int)position andDefaulImageUrl:(NSString *)defImageUrl;
-(NSString *)description;




@end
