//
//  TSDetailsViewController.m
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 2/15/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "TSDetailsViewController.h"

@interface TSDetailsViewController () {
    //The CLLocationManager is the object that provides you the location data
    CLLocationManager *locationManager;
    
    //Object to store the retrieved location
    CLLocation *currentLocation;
}

@end

@implementation TSDetailsViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}
-(void)viewWillDisappear:(BOOL)animated {
    
    
    //Store the longitude and latitude
    if (currentLocation != nil) {
        self.detailedTS.longitude = currentLocation.coordinate.longitude;
        self.detailedTS.latitude = currentLocation.coordinate.latitude;
    }
    
    [self.delegate passTSToGameBoardViewController:self didFinishEditingTS:self.detailedTS];
    
}

- (void) viewWillAppear:(BOOL)animated {
    
    if (self.detailedTS.userImageUrl) {
        self.tsUserImage.image = [self loadImageWithName:self.detailedTS.userImageUrl];
        
        NSTimeInterval interval = [self.detailedTS.timestamp timeIntervalSinceDate:self.currentGame.startDate];
        NSUInteger seconds = ABS((int)interval);
        NSUInteger minutes = seconds/60;
        NSUInteger hours = minutes/60;
     
        self.tsInfoLabel.text = [NSString  stringWithFormat:@"%@\n%02lu:%02lu:%02lu",
                                 self.detailedTS.timestamp, hours, minutes%60, seconds%60];

        if (self.detailedTS.longitude) {
            
            CLLocationCoordinate2D coord;
            coord.longitude = (CLLocationDegrees) self.detailedTS.longitude;
            coord.latitude = (CLLocationDegrees) self.detailedTS.latitude;
            [self setSignPositionOnMap:coord];
        }
        else {
            //Initialize location manager
            locationManager = [[CLLocationManager alloc]init];
            locationManager.delegate = self;
            locationManager.desiredAccuracy = kCLLocationAccuracyBest;
            
            //Start Updating location
            [locationManager startUpdatingLocation];
        }
    }
    else {
        
        self.tsUserImage.image = [UIImage imageNamed:@"takePicturePlaceholder.png"];
        self.tsInfoLabel.text = [NSString  stringWithFormat:@"Not Available yet"];

    }
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    self.signTitle.text = self.detailedTS.name;
    self.tsDefaultImage.image = [UIImage imageNamed:self.detailedTS.defaultImageUrl];
    [self.tsDefaultImage.layer setBorderColor: [[UIColor redRTB] CGColor]];
    [self.tsDefaultImage.layer setBorderWidth: 2.0];
    [self.tsUserImage.layer setBorderColor: [[UIColor redRTB] CGColor]];
    [self.tsUserImage.layer setBorderWidth: 2.0];
    [self.mapView.layer setBorderColor:[[UIColor redRTB] CGColor]];
    [self.mapView.layer setBorderWidth: 2.0];
    
    self.mapView.delegate = self;
    
}

                                     
- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)didTapPicture:(UITapGestureRecognizer *)sender {
    if (!self.currentGame.gotBingo) {
        UIActionSheet *actionSheet = [[UIActionSheet alloc]initWithTitle:Nil delegate:self cancelButtonTitle:@"Cancel" destructiveButtonTitle:Nil otherButtonTitles:@"Take a photo", @"Use photo library", nil];
        [actionSheet showInView:self.view];
    }
    
    
}

- (void)actionSheet:(UIActionSheet *)actionSheet didDismissWithButtonIndex:(NSInteger)buttonIndex {
    
    if (buttonIndex == actionSheet.cancelButtonIndex) {
        return;
    }
    switch (buttonIndex) {
        case 0:
            if (![UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]){
                NSLog(@"No camera detected");
                return;
            }
            [self useCamera];
            break;
        case 1:
            [self useCameraRoll];
            break;
        default:
            break;
    }
    
}


#pragma mark - User Defined Methods

- (void)useCamera {
    if ([UIImagePickerController isSourceTypeAvailable: UIImagePickerControllerSourceTypeCamera])
    {
        UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
        imagePicker.delegate = self;
        imagePicker.sourceType = UIImagePickerControllerSourceTypeCamera;
        
        //kUTTypeImage needs to --> #import <MobileCoreServices/MobileCoreServices.h>
        imagePicker.mediaTypes = @[(NSString *) kUTTypeImage];
        imagePicker.allowsEditing = NO;
        [self presentViewController:imagePicker animated:YES completion:nil];
    }
}

- (void)useCameraRoll {
    if ([UIImagePickerController isSourceTypeAvailable: UIImagePickerControllerSourceTypeSavedPhotosAlbum])
    {
        UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
        imagePicker.delegate = self;
        imagePicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
        
        //kUTTypeImage needs to --> #import <MobileCoreServices/MobileCoreServices.h>
        imagePicker.mediaTypes = @[(NSString *) kUTTypeImage];
        imagePicker.allowsEditing = NO;
        [self presentViewController:imagePicker animated:YES completion:nil];
    }
}

//Returns an image with a given fileName, from the app directory
- (UIImage*)loadImageWithName: (NSString *) fileName
{
    NSString *homePath = NSHomeDirectory();
    NSString* path = [homePath stringByAppendingPathComponent:
                      [NSString stringWithFormat:@"/Documents/userSigns/%@",fileName]];
    UIImage* image = [UIImage imageWithContentsOfFile:path];
    return image;
}


//Saves a given image to the app directory, with the given filename
- (BOOL)saveImage: (UIImage*)image withFileName: (NSString *)fileName
{
    if (image != nil)
    {
        NSString *homePath = NSHomeDirectory();
        NSString *userSignsDirectory = [homePath stringByAppendingPathComponent:@"/Documents/userSigns"];
        
        if ([self checkOrCreateFolder:userSignsDirectory]) {
            NSString* userImageFilePath = [userSignsDirectory stringByAppendingPathComponent:fileName];
            
            NSData *data = UIImagePNGRepresentation(image);
            [data writeToFile:userImageFilePath atomically:YES];
            return true;
        }
        else return FALSE;
    } else return FALSE;
}


// Function that checks if a given path exists, and creates it otherwise
- (BOOL) checkOrCreateFolder: (NSString *)path {
    
    BOOL isDir, success = NO;
    NSError *error = Nil;
    
    NSFileManager *fileManager= [NSFileManager defaultManager];
    if(![fileManager fileExistsAtPath:path isDirectory:&isDir])
    {
        if(![fileManager createDirectoryAtPath:path withIntermediateDirectories:YES attributes:Nil error:&error]){
            NSLog(@"Error: Create folder failed %@\nERROR: %@", path, error);
            success = NO;
            
        }
        else {
            NSLog(@"Success: Create folder success %@", path);
            success = YES;
        }
        
    } else {
        NSLog(@"\nFolder Exists!! %@",path);
        success = YES;
    }
    return success;
}


- (void) setSignPositionOnMap: (CLLocationCoordinate2D) coordinate {

    // Create the annotation
    MKPointAnnotation *point = [[MKPointAnnotation alloc] init];
    point.coordinate = coordinate;
    
    //point.title = self.detailedTS.name;
    //point.subtitle = @"I'm here!!!";
    
    [self.mapView addAnnotation:point];
    
    MKCoordinateRegion region = MKCoordinateRegionMakeWithDistance(coordinate, 800, 800);
    [self.mapView setRegion:region animated:YES];
    [self.mapView selectAnnotation:point animated:YES];

}


#pragma mark - Delegation Methods

- (void) imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {
    
    UIImage *image = info[UIImagePickerControllerOriginalImage];
    
    //Reduce image size to area in the app
    UIImage *thumbnail = [image createThumbnail:image withSize:self.tsUserImage.frame.size];

    //Timestamp for the image filename and for the game data
    NSDate *picDate = [NSDate date];
    
    NSDateFormatter *df = [[NSDateFormatter alloc] init];
    [df setDateFormat:@"yyyyMMddHHmmss"];
    
    NSString *imageName = [NSString stringWithFormat: @"%@.png", [df stringFromDate:picDate]];
    
    //If the image is correctly saved, save info to the GameTrafficSign Object
    if ([self saveImage:thumbnail withFileName:imageName]) {
        self.detailedTS.userImageUrl = imageName;
        self.detailedTS.timestamp = picDate;
        self.detailedTS.hasBeenUpdated = YES;
    }
    else {
        //TODO: ERROR MESSAGE TO USER
        NSLog(@"\nError saving image with name: %@", imageName);
    }
    
    [picker dismissViewControllerAnimated:YES completion:Nil];

}

-(void)imagePickerControllerDidCancel:(UIImagePickerController *)picker
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - CLLocationManagerDelegate

- (void)locationManager:(CLLocationManager *)manager didFailWithError:(NSError *)error
{
    NSLog(@"didFailWithError: %@", error);
    UIAlertView *errorAlert = [[UIAlertView alloc]
                               initWithTitle:@"Error" message:@"Failed to Get Your Location" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [errorAlert show];
}

- (void)locationManager:(CLLocationManager *)manager didUpdateToLocation:(CLLocation *)newLocation fromLocation:(CLLocation *)oldLocation
{
    NSLog(@"didUpdateToLocation: %@", newLocation);
    
    //Save the current Location
    //CLLocation *currentLocation = newLocation;
    currentLocation = newLocation;
    
    //Retrieve current location
    if (currentLocation != nil) {
        
        //Set Annotation on Map
        [self setSignPositionOnMap:currentLocation.coordinate];
        
        
    }
    
    // Stop Location Manager Updating Location
    [locationManager stopUpdatingLocation];
  
}



- (IBAction)backButton:(id)sender {
    [[self navigationController] popViewControllerAnimated:YES];
}
@end
