//
//  TripDetailViewController.h
//  TripsApp
//
//  Created by admin on 2/19/14.
//  Copyright (c) 2014 admin. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <sqlite3.h>
#import "Record.h"
#import <MobileCoreServices/MobileCoreServices.h>
#import <AssetsLibrary/AssetsLibrary.h>
#import "LocationHandler.h"

@interface TripDetailViewController : UIViewController
 <UIImagePickerControllerDelegate,
 UINavigationControllerDelegate,
 LocationHandlerDelegate>

@property (weak, nonatomic) IBOutlet UITextField *destination;
@property (weak, nonatomic) IBOutlet UITextField *month;
@property (weak, nonatomic) IBOutlet UITextField *year;
@property (weak, nonatomic) IBOutlet UITextView *comments;
@property (weak, nonatomic) IBOutlet UIImageView *imageView;
@property (weak, nonatomic) IBOutlet UILabel *longLabel;
@property (weak, nonatomic) IBOutlet UILabel *latLabel;

@property (strong, nonatomic) NSMutableArray *tripDetails;

@property (strong, nonatomic) NSString *databasePath;
@property (nonatomic) sqlite3 *tripsDB;

@property (strong, nonatomic) NSNumber *strongNum;

@property BOOL newPic;
@property BOOL newTrip;
@property (strong, nonatomic) NSNumber *idForPic;

- (void)initDatabase;
- (void)insertData;
- (void)updateData;
- (void)validateMonth;
- (BOOL)validateYear;
- (void)currentDate;

- (IBAction)Save:(id)sender;
- (IBAction)Done:(id)sender;

@end
