//
//  TripDetailViewController.m
//  TripsApp
//
//  Created by admin on 2/19/14.
//  Copyright (c) 2014 admin. All rights reserved.
//

#import "TripDetailViewController.h"

// This is where we add/edit the trip details... initial development for add only

@interface TripDetailViewController (){
    NSNumber *lastId;
    
}


@end

@implementation TripDetailViewController

NSNumber *testVar;


- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

-(void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}

- (BOOL)textFieldShouldReturn:(UITextField *) textField {
    [textField resignFirstResponder];

     [_destination resignFirstResponder];
     [_month resignFirstResponder];
     [_year resignFirstResponder];
     [_comments resignFirstResponder];
    
    /*
         [textField resignFirstResponder];
    */
    return YES;  //OBJ C Bool is always YES or NO in caps
   }

- (void)viewDidLoad
{
    NSLog(@"TripViewDetailController  ViewDidLoad begin");
    //self.navigationItem.title = @"why wont it update ???";
    [super viewDidLoad];
    [[LocationHandler getSharedInstance]setDelegate:self];
    [[LocationHandler getSharedInstance]startUpdating];


//
    lastId = _tripDetails[0];
    _destination.text = _tripDetails[1];
    _month.text = _tripDetails[2];
    _year.text = _tripDetails[3];
    _comments.text = _tripDetails[4];
    _imageView.image = [UIImage imageNamed:_tripDetails[5]];
    
    if (lastId == NULL) {
        _newTrip = "YES";
//        NSLog(@"Trip Detail ViewDidLoad **** NEW TRIP %hhd  LastID: %@ ", _newTrip, lastId);
//    }else{
//        NSLog(@"Trip Detail ViewDidLoad NO NEW TRIP %hhd  LastID: %@ ", _newTrip, lastId);
    }
    
    // Create database if it has not been created yet
    [self initDatabase];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
-(void)didUpdateToLocation:(CLLocation *)newLocation
              fromLocation:(CLLocation *)oldLocation{
    [_latLabel setText:[NSString stringWithFormat:
                            @"Latitude: %f",newLocation.coordinate.latitude]];
    [_longLabel setText:[NSString stringWithFormat:
                             @"Longitude: %f",newLocation.coordinate.longitude]];
}

- (IBAction)Save:(id)sender {
 
    // validate all mandatory input data
    if ([self validateYear]){
    // proper case month
    [self validateMonth];
    //save or update data if month and year are valid
    const char *dbpath = [_databasePath UTF8String];

    if (sqlite3_open(dbpath, &_tripsDB) == SQLITE_OK) {
        NSLog(@"open trips database OK  %d", sqlite3_open(dbpath, &_tripsDB));
        if (_newTrip) {
                NSLog(@"TripDetailView insertData Add new trip  -doneSave _databasePath %@",_databasePath );
            [self insertData];
        } else {
                NSLog(@"TripDetailView updateData  -doneSave _databasePath %@",_databasePath );
            [self updateData];
         }
    
//    lastId = [[NSNumber alloc] initWithLongLong:sqlite3_last_insert_rowid(_tripsDB)];
//    _strongNum = lastId;
//    testVar = _strongNum;
    sqlite3_close(_tripsDB);
    } //end SQLITE_OK
    } //end validate year
}

- (IBAction)Done:(id)sender {
    
    [self dismissViewControllerAnimated:YES completion:nil];
}


- (void) validateMonth;
{
 // case statement?
    NSString *month = _month.text;
    NSString *propMonth = [self stringToTitleCase: month ];
    // proper case the month that is entered
    _month.text = propMonth;
    
}
- (NSString *) stringToTitleCase: (NSString *) inString
{
    NSString *firstLetter = [inString substringWithRange: NSMakeRange(0, 1)];
    NSString *theRest = [inString substringWithRange: NSMakeRange(1, [inString length]-1)];
    
    return [NSString stringWithFormat: @"%@%@", [firstLetter uppercaseString], theRest];
}

- (BOOL) validateYear;
{
    // only allow > 1900 and < 2100
    NSString *s = _year.text;
    int yearValue = [s intValue];
    
    if (yearValue < 2050 & yearValue > 1990) {
          //NSLog(@" i OK %i", yearValue);
        return YES;
    }else{
         //NSLog(@" i NOT OK %i", yearValue);
        
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Year is not Valid" message:@"Please enter a year between 1900 and 2100" delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:nil];
        // optional - add more buttons:
        //[alert addButtonWithTitle:@"Yes"];
        [alert show];
        return NO;
    }
   //Add month validation to see if it can be grouped together
    
    if (_month.text.length > 3 & _month.text.length < 8 ) {
//        If(_month.text = @"January"); | (_month.text = @"January" );{
//                  return YES;
//        }

        return YES;

    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Month is not Valid" message:@"Please enter a valid month" delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:nil];
        // optional - add more buttons:
        //[alert addButtonWithTitle:@"Yes"];
        [alert show];
        return NO;
    }
    
    //Add destination validation to see if it can be grouped together
    
    if (_destination.text.length > 0) {
        return YES;
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Destination is not Valid" message:@"Please enter a destination/location for this set of pictures" delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:nil];
        // optional - add more buttons:
        //[alert addButtonWithTitle:@"Yes"];
        [alert show];
        return NO;
    }
}

- (void) updateData;
{
    sqlite3_stmt *statement;
    NSString *updateSQL = [NSString stringWithFormat:@"UPDATE TRIPDETAIL set destination = '%@', month = '%@', year = '%@', comment = '%@' WHERE ID = '%@'",
                           _destination.text,
                           _month.text,
                           _year.text,
                           _comments.text,
                           lastId];
    
    const char *update_stmt = [updateSQL UTF8String];
    
    // this will run the query
    int success = sqlite3_prepare_v2(_tripsDB, update_stmt, -1, &statement, NULL);
    
    if(success != SQLITE_OK) {
        NSLog(@"update stmt failed %d", success);
    }
    // this will test queries success
    if (sqlite3_step(statement)==SQLITE_DONE){
        NSLog(@"TRIPDETAIL Updated: LastID = %@", lastId);
        
    } else {
        NSLog( @"Failed from sqlite3_step(statement) Error is:  %s",sqlite3_errmsg(_tripsDB));
        NSLog(@"failed to update trip %d", sqlite3_step(statement));
    }
//    lastId = [[NSNumber alloc] initWithLongLong:sqlite3_last_insert_rowid(_tripsDB)];
//    NSLog(@"TRIPDETAIL updateData LastID = %@", lastId);
//    _strongNum = lastId;
//    testVar = _strongNum;
    sqlite3_finalize(statement);
}

- (void) insertData;
{
    sqlite3_stmt *statement;
    
    NSLog(@"TripDetailView saveData: databasePath %@",_databasePath );
    NSString *insertSQL = [NSString stringWithFormat:
                           @"INSERT INTO TRIPDETAIL (destination,month,year,comment) VALUES (\"%@\", \"%@\", \"%@\", \"%@\")",
                           _destination.text, _month.text, _year.text, _comments.text ];
    const char *insert_stmt = [insertSQL UTF8String];
    // this will run the query
    int success = sqlite3_prepare_v2(_tripsDB, insert_stmt, -1, &statement, NULL);
    
    if(success != SQLITE_OK) {
        NSLog(@"create stmt failed %d", success);
    }
 
    if (sqlite3_step(statement)==SQLITE_DONE){
       NSLog(@"TRIPDETAIL Inserted: Destination = %@", _destination.text);
        _destination.text = @" ";
        _month.text = @" ";
        _year.text = @" ";
        _comments.text = @" ";
        
    } else {
        NSLog( @"Failed from sqlite3_step(statement) Error is:  %s",sqlite3_errmsg(_tripsDB));
        NSLog(@"failed to add trip %d", sqlite3_step(statement));
    }
//    lastId = [[NSNumber alloc] initWithLongLong:sqlite3_last_insert_rowid(_tripsDB)];
//    NSLog(@"TRIPDETAIL saveData LastID = %@", lastId);
//    _strongNum = lastId;
//    testVar = _strongNum;
    sqlite3_finalize(statement);
}


- (void) initDatabase;
{
    NSString *docsDir;
    NSArray *dirPaths;
    NSString *newDir;
    NSFileManager *filemgr = [NSFileManager defaultManager];
    //  NSLog(@"Trip Detail filemgr %@", filemgr );
    
    newDir = [docsDir stringByAppendingPathComponent:@"pics"];
    //newDir = [docsDir stringByAppendingPathComponent:@"data"];
    // NSLog(@"Trip Detail newDir %@",newDir );
    
    if ([filemgr fileExistsAtPath: newDir ] == NO) {
        //NSLog(@"Trip Detail filemgr fileExistsAtPath: newDir ] == NO");
    }
    
    if ([filemgr createDirectoryAtPath:newDir withIntermediateDirectories:YES
                            attributes:nil error: NULL] == NO)
    {
        // Failed to create directory
        //NSLog(@"Trip Detail Failed to create directory");
    }
    
    dirPaths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    docsDir = dirPaths[0];
    _databasePath = [[NSString alloc] initWithString:[docsDir stringByAppendingPathComponent:@"trips.db"]];
    
    if ([filemgr fileExistsAtPath: _databasePath] == NO)
    {
        const char *dbpath = [_databasePath UTF8String];

        if (sqlite3_open(dbpath, &_tripsDB) == SQLITE_OK)
        {
            char *errMsg;
            const char *sql_stmt =
            "CREATE TABLE IF NOT EXISTS TRIPDETAIL (ID INTEGER PRIMARY KEY AUTOINCREMENT, DESTINATION TEXT, MONTH TEXT, YEAR TEXT, COMMENT TEXT, IMAGENAME TEXT)";
            
            if (sqlite3_exec(_tripsDB, sql_stmt, NULL, NULL, &errMsg) != SQLITE_OK) {
                NSLog(@"failed to create table");
            } else {
                sqlite3_close(_tripsDB);
            }
        } else {
            NSLog(@"failed to open/create table");
        }
    }
}


- (void)currentDate;
{
    NSDate *now = [NSDate date]; //now: YYYY-MM-DD HH:MM:SS +mmmm
    NSLog(@"now: %@", now);
    
    NSString *strDate = [[NSString alloc] initWithFormat:@"%@",now];
    NSArray *arr = [strDate componentsSeparatedByString:@" "];
    NSString *str;
    str = [arr objectAtIndex:0]; NSLog(@"strdate: %@",str); // strdate: YYYY-MM-DD
    NSArray *arr_my = [str componentsSeparatedByString:@"-"];
    
    NSInteger date = [[arr_my objectAtIndex:2] intValue];
    NSInteger month = [[arr_my objectAtIndex:1] intValue];
    NSInteger year = [[arr_my objectAtIndex:0] intValue];
    
    NSLog(@"year = %d", year); // year = YYYY
    NSLog(@"month = %d", month); // month = M
    NSLog(@"date = %d", date); // date = D
}


@end
