//
//  TripsMainTableViewController.m
//  TripsApp
//
//  Created by Val on 3/1/14.
//  Copyright (c) 2014 admin. All rights reserved.
//

#import "TripsMainTableViewController.h"
#import "TripsAppCell.h"
#import "TripDetail.h"

@interface TripsMainTableViewController (){
    NSNumber *lastId;
}

@end

@implementation TripsMainTableViewController

NSNumber *testVar;
@synthesize allTrips;


- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    //NSLog(@"failed to add trip %d", sqlite3_step(statement));
  //  NSLog(@"TripsMainTableViewController.m    ViewDidLoad");
    [self tripList];
    self.navigationItem.title = @"Picture Log";
    self.tableView.separatorColor = [UIColor colorWithRed:0/255.0 green:181/255.0 blue:13/255.0 alpha:0.8];
    
    
    [super viewDidLoad];
    }


-(NSMutableArray *) tripList {
             allTrips = [[NSMutableArray alloc] initWithCapacity:10];
    
    NSString *docsDir;
    NSArray *dirPaths;
    // Get the document directory
    dirPaths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    docsDir = dirPaths[0];
    
    //Identifies the application's Documents directory and constructs a path to the trips.db database file
    //NSLog(@"Trip Detail docsDir %@",docsDir );
    
    _databasePath = [[NSString alloc] initWithString:[docsDir stringByAppendingPathComponent:@"trips.db"]];
    NSFileManager *filemgr = [NSFileManager defaultManager];
   // NSLog(@"TripList1 filemgr %@", filemgr );
    if ([filemgr fileExistsAtPath: _databasePath] == NO) {
      //  NSLog(@"TripList failed to find DB path");
    }
  //  NSLog(@"TripList2  _databasePath =  %@",_databasePath );
    sqlite3_stmt *statement;
    const char *dbpath = [_databasePath UTF8String];
 
    if (sqlite3_open(dbpath, &_tripsDB) == SQLITE_OK) {
       //NSLog(@"TripList3 open trips database OK  %d", sqlite3_open(dbpath, &_tripsDB));
        //
        NSString *selectSQL =  @"SELECT * FROM TRIPDETAIL ORDER BY MONTH,YEAR";
        //NSString *selectSQL =  @"SELECT destination,month,year FROM TRIPDETAIL";

        const char *select_stmt = [selectSQL UTF8String];
        //        // this will run the query
        int success = sqlite3_prepare_v2(_tripsDB, select_stmt, -1, &statement, NULL);
        //
        if (success != SQLITE_OK) {
           // NSLog(@"TripList4 ** Select stmt failed %d", success);
        } else {
            NSLog(@"TripList4 ** Select stmt worked " );
             // populate array
            while (sqlite3_step(statement)==SQLITE_ROW) {
                //NSLog(@" populate array " );
                TripDetail * tripdetail = [[TripDetail alloc]init];
                tripdetail.key = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement,0)];
                tripdetail.destination = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement,1)];
               // NSLog(@" Array Populated: %@", tripdetail.destination);
                tripdetail.month = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement,2)];
                //NSLog(@" Array Populated: %@", tripdetail.month);
                tripdetail.year = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement,3)];
                //NSLog(@" Array Populated: %@", tripdetail.year);
                tripdetail.comment = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement,4)];
                //NSLog(@" Array Populated: %@", tripdetail.comment);
                tripdetail.imagePath = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement,5)];
        //NSLog(@"TripList5 ** Select stmt worked " );

                [allTrips addObject:tripdetail];
                    tripdetail=nil;
                
            }
            sqlite3_finalize(statement);
          //NSLog(@" Array Populated ...  Number of rows in database: %i",   allTrips.count);
            sqlite3_close(_tripsDB);
//            lastId = [[NSNumber alloc] initWithLongLong:sqlite3_last_insert_rowid(_tripsDB)];
//            _strongNum = lastId;
//            testVar = _strongNum;
            //NSLog(@"Trip Detail View Controller Last ID selected %@", lastId);
            
        }
    }

    return allTrips;
}



- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [[self tableView] reloadData];
}


- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
 //return [self.content count];
    //return _tripDestination.count;
    //NSLog(@" numberOfRowsInSection  %i", [allTrips count] );
    return [allTrips count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"TripsCell";
    
    TripsAppCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier forIndexPath:indexPath];
    
    long row = [indexPath row];
    // int row = [indexPath row];
    
    TripDetail * tripdetail = [self.allTrips objectAtIndex:row];
    
    cell.tripDestination.text = tripdetail.destination;
    //NSString *saveMonth = [tripdetail month] & @" , " & [tripdetail month];
    NSString *strMonthYear = [NSString stringWithFormat: @"%@, %@ ", tripdetail.month, tripdetail.year];

    cell.tripMonth.text = strMonthYear;
    //cell.tripYear.text = tripdetail.year;
    cell.tripImage.image = [UIImage imageNamed: tripdetail.imagePath];
// NSData *imageDataFromDb = [[NSData alloc]initWithBytes:sqlite3_column_blob(compiledStatement, 3) length:sqlite3_column_bytes(compiledStatement, 3)];
    return cell;
    
}

 #pragma mark - Navigation
 
 
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
 {
 // Get the new view controller using [segue destinationViewController].
     
     if ([[segue identifier] isEqualToString:@"TripDetails"]) {
         // When table cell is pressed, indicate which detail view controller to go to
     TripDetailViewController *detailViewController = [segue destinationViewController];
       
        NSIndexPath *myIndexPath = [self.tableView indexPathForSelectedRow];
        int row = [myIndexPath row];
         
         // create an array to send to detail view
         TripDetail * tripdetail = [self.allTrips objectAtIndex:row];
         NSString *key = [tripdetail key];
         NSString *destin = [tripdetail destination];
         NSString *monthtosend = [tripdetail month];
         NSString *yeartosend = [tripdetail year];
         NSString *commtosend = [tripdetail comment];
         NSString *imagetosend = [tripdetail imagePath];
         NSMutableArray *mystr = [[NSMutableArray alloc] initWithObjects:key,destin,monthtosend,yeartosend,commtosend,imagetosend,nil];
    
         detailViewController.tripDetails = mystr;
        NSLog(@"Whats up %@", detailViewController.tripDetails);
        
//
     }
    
 // Pass the selected object to the new view controller.
     /*
     old, after NSIndexPath
      
      detailViewController.tripDetails = @[_tripDestination[row],_tripMonth[row],_tripYear[row],_tripComment[row],_tripImage[row]];
      
      */
 }



@end
