<?
function imageToPng($srcFile,$num, $maxSize = 100) {  
    list($width_orig, $height_orig, $type) = getimagesize($srcFile);        
 
    // Get the aspect ratio
    $ratio_orig = $width_orig / $height_orig;
 
    $width  = $maxSize; 
    $height = $maxSize;
 
    // resize to height (original is portrait) 
    if ($ratio_orig < 1) {
        $width = $height * $ratio_orig;
    } 
    // resize to width (original is landscape)
    else {
        $height = $width / $ratio_orig;
    }
 
    // Temporarily bump up the memory limit to allow for larger images
    ini_set('memory_limit', '32M'); 
 
    switch ($type) 
    {
        case IMAGETYPE_GIF: 
            $image = imagecreatefromgif($srcFile); 
            break;   
        case IMAGETYPE_JPEG:  
            $image = imagecreatefromjpeg($srcFile); 
            break;   
        case IMAGETYPE_PNG:  
            $image = imagecreatefrompng($srcFile);
            break; 
        default:
            throw new Exception('Unrecognized image type ' . $type);
    }
 
    // create a new blank image
    $newImage = imagecreatetruecolor($width, $height);
 
    // Copy the old image to the new image
    imagecopyresampled($newImage, $image, 0, 0, 0, 0, $width, $height, $width_orig, $height_orig);
 
    // Output to a temp file
    imagepng($newImage, 'converted/'.$num.'.png');  
 

 
}



$i = 1;
while ($i<=25){
imageToPng('thumbnails/'.$i.'.jpg',$i,50);
$i++;
}


?>
 