//
//  DelegateViewController.m
//  DelegateDemo
//
//  Created by Kristian Secor on 2/18/14.
//  Copyright (c) 2014 Kristian Secor. All rights reserved.
//
/*
 object A calls object B to perform an action, 
 once the action is complete object A should know that B has completed the task and take necessary action.
 This is achieved with the help of delegates.
 
 The key concepts in the above example are,
 
 A is delegate object of B
 
 B will have a reference of A
 
 A will implement the delegate methods of B.
 
 B will notify A through the delegate methods.
 */
 
 
#import "DelegateViewController.h"

@interface DelegateViewController ()

@end

@implementation DelegateViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    SampleProtocol *sampleProtocol = [[SampleProtocol alloc]init];
    sampleProtocol.delegate = self;
    [_myLabel setText:@"Processing..."];
    [sampleProtocol startSampleProcess];
    // Do any additional setup after loading the view, typically from a nib.
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - Sample protocol delegate
-(void)processCompleted{
    [_myLabel setText:@"Process Completed"];
}

@end
