//
//  DatabaseViewController.m
//  Database
//
//  Created by Neil Smyth on 9/18/13.
//  Copyright (c) 2013 Neil Smyth. All rights reserved.
//

#import "DatabaseViewController.h"
@interface DatabaseViewController (){
    NSNumber *lastId;
}


@end



@implementation DatabaseViewController

NSNumber *testVar;

- (void)viewDidLoad
{
    [super viewDidLoad];
    NSString *docsDir;
    NSArray *dirPaths;


    // Get the documents directory
    dirPaths = NSSearchPathForDirectoriesInDomains(
      NSDocumentDirectory, NSUserDomainMask, YES);

    docsDir = dirPaths[0];

    // Build the path to the database file
    _databasePath = [[NSString alloc]
       initWithString: [docsDir stringByAppendingPathComponent:
       @"contacts.db"]];

    NSFileManager *filemgr = [NSFileManager defaultManager];

    if ([filemgr fileExistsAtPath: _databasePath ] == NO)
    {
       const char *dbpath = [_databasePath UTF8String];
      
        //& is the C address-of unary operator. It returns the memory address of its operand.
    
       if (sqlite3_open(dbpath, &_contactDB) == SQLITE_OK)
       {
            char *errMsg;
            const char *sql_stmt =
           "CREATE TABLE IF NOT EXISTS CONTACTS (ID INTEGER PRIMARY KEY AUTOINCREMENT, NAME TEXT, ADDRESS TEXT, PHONE TEXT, IMAGE BLOB)";

            if (sqlite3_exec(_contactDB, sql_stmt, NULL, NULL, &errMsg) != SQLITE_OK)
            {
                 _status.text = @"Failed to create table";
            }
            sqlite3_close(_contactDB);
        } else {
                 _status.text = @"Failed to open/create database";
        }
     }
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)saveData:(id)sender {
    [self.name resignFirstResponder];
    [self.address resignFirstResponder];
    [self.phone resignFirstResponder];
    
     //sqlite3_stmt    *statement;
     const char *dbpath = [_databasePath UTF8String];

     if (sqlite3_open(dbpath, &_contactDB) == SQLITE_OK)
     {
         
/*
           NSString *insertSQL = [NSString stringWithFormat:
             @"INSERT INTO CONTACTS (name, address, phone, image) VALUES (\"%@\", \"%@\", \"%@\", \"%@\")",
             _name.text, _address.text, _phone.text, _contactPicture.image];

           const char *insert_stmt = [insertSQL UTF8String];
           sqlite3_prepare_v2(_contactDB, insert_stmt,
             -1, &statement, NULL);
            if (sqlite3_step(statement) == SQLITE_DONE)
            {
                 _status.text = @"Contact added";
 
            } else {
                 _status.text = @"Failed to add contact";
            }
        lastId = [[NSNumber alloc] initWithLongLong:sqlite3_last_insert_rowid(_contactDB)];
         _strongNum = lastId;
         testVar = _strongNum;
         sqlite3_finalize(statement);
        sqlite3_close(_contactDB);
*/
         
         NSLog( @"\n*****Save image to SQLite*****\n" );
         
         
         NSData *imageData = UIImagePNGRepresentation(_contactPicture.image);
         
         const char* sqliteQuery = "INSERT INTO CONTACTS (NAME, ADDRESS, PHONE, IMAGE) VALUES (?, ?, ?, ?)";
         sqlite3_stmt* statement;
         
         if( sqlite3_prepare_v2(_contactDB, sqliteQuery, -1, &statement, NULL) == SQLITE_OK )
         {
             
             sqlite3_bind_text(statement, 1, [_name.text UTF8String], -1, SQLITE_TRANSIENT);
             sqlite3_bind_text(statement, 2, [_address.text UTF8String], -1, SQLITE_TRANSIENT);
             sqlite3_bind_text(statement, 3, [_phone.text UTF8String], -1, SQLITE_TRANSIENT);
             sqlite3_bind_blob(statement, 4, [imageData bytes], [imageData length], SQLITE_TRANSIENT);
             sqlite3_step(statement);
             
             _status.text = @"Contact Added";
             _name.text = @"";
             _address.text = @"";
             _phone.text = @"";
             _contactPicture.image = Nil;
         }
         else NSLog( @"SaveBody: Failed from sqlite3_prepare_v2. Error is:  %s", sqlite3_errmsg(_contactDB) );
         
         // Finalize and close database.
         sqlite3_finalize(statement);
         sqlite3_close(_contactDB);
         
    }

}

- (IBAction)findContact:(id)sender {
    [self.name resignFirstResponder];
    [self.address resignFirstResponder];
    [self.phone resignFirstResponder];
     const char *dbpath = [_databasePath UTF8String];
     sqlite3_stmt    *statement;

     if (sqlite3_open(dbpath, &_contactDB) == SQLITE_OK)
     {
             NSString *querySQL = [NSString stringWithFormat:
               @"SELECT address, phone, image FROM contacts WHERE name=\"%@\"",
               _name.text];

             const char *query_stmt = [querySQL UTF8String];

             if (sqlite3_prepare_v2(_contactDB,
                 query_stmt, -1, &statement, NULL) == SQLITE_OK)
             {
                     if (sqlite3_step(statement) == SQLITE_ROW)
                     {
                         NSString *addressField = [[NSString alloc]
                                initWithUTF8String:
                                (const char *) sqlite3_column_text(
                                  statement, 0)];
                             _address.text = addressField;
                         NSString *phoneField = [[NSString alloc]
                                 initWithUTF8String:(const char *)
                                 sqlite3_column_text(statement, 1)];
                         
                         
                         int length = sqlite3_column_bytes(statement, 2);
                         NSData *data       = [NSData dataWithBytes:sqlite3_column_blob(statement, 2) length:length];
                         
                         UIImage *imageField  = [[UIImage alloc]initWithData:data];
                         
                         _phone.text = phoneField;
                         _status.text = @"Match found";
                         _contactPicture.image = imageField;
                     } else {
                             _status.text = @"Match not found";
                             _address.text = @"";
                             _phone.text = @"";
                         _contactPicture.image = Nil;
                     }
                     sqlite3_finalize(statement);
             }
             sqlite3_close(_contactDB);
         
  /*       NSData* data = nil;
         NSString* sqliteQuery = [NSString stringWithFormat:@"SELECT IMAGE FROM IMAGES WHERE URL = '%@'", imageLink];
         sqlite3_stmt* statement;
         
         if( sqlite3_prepare_v2(articlesDB, [sqliteQuery UTF8String], -1, &statement, NULL) == SQLITE_OK )
         {
             if( sqlite3_step(statement) == SQLITE_ROW )
             {
                 int length = sqlite3_column_bytes(statement, 0);
                 data       = [NSData dataWithBytes:sqlite3_column_blob(statement, 0) length:length];
             }
         }
         
         // Finalize and close database.
         sqlite3_finalize(statement);
         
         return data;
*/
     }

}

-(void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender{
   //CameraViewController *camViewController = segue.destinationViewController;
    
    CameraViewController *camViewController = segue.destinationViewController;
    camViewController.delegate = self;
  
    NSLog(@"test %@",lastId );
    NSLog(@" strong  num is %@",_strongNum);
    NSLog(@" other  num is %@",testVar);

   //NSLog(@"obj is %@",se;);

}
- (void)addPictureViewController:(CameraViewController *)controller didFinishEnteringItem:(UIImage *)item {
    self.contactPicture.image = item;
}


- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    
   /* UITouch *touch = [[event allTouches] anyObject];
    if ([_phone isFirstResponder] && [touch view] != _phone) {
        [_phone resignFirstResponder];
    }
    [super touchesBegan:touches withEvent:event];
    */
    [self.view endEditing:YES];
}
@end
