//
//  DatabaseViewController.m
//  Database
//
//  Created by Neil Smyth on 9/18/13.
//  Copyright (c) 2013 Neil Smyth. All rights reserved.
//

#import "DatabaseViewController.h"
@interface DatabaseViewController (){
    NSNumber *lastId;
}


@end



@implementation DatabaseViewController

NSNumber *testVar;

- (void)viewDidLoad
{
    [super viewDidLoad];
    NSFileManager *filemgr;

    NSString *docsDir;
    NSArray *dirPaths;

    NSString *newDir;
    
   filemgr = [NSFileManager defaultManager];

    newDir = [docsDir stringByAppendingPathComponent:@"pics"];
    
    
    if ([filemgr fileExistsAtPath: newDir ] == NO) {

    }
    
    if ([filemgr createDirectoryAtPath:newDir withIntermediateDirectories:YES
                            attributes:nil error: NULL] == NO)
    {
        // Failed to create directory
    }

    // Get the documents directory
    dirPaths = NSSearchPathForDirectoriesInDomains(
      NSDocumentDirectory, NSUserDomainMask, YES);

    docsDir = dirPaths[0];

    // Build the path to the database file
    _databasePath = [[NSString alloc]
       initWithString: [docsDir stringByAppendingPathComponent:
       @"contacts.db"]];


    if ([filemgr fileExistsAtPath: _databasePath ] == NO)
    {
       const char *dbpath = [_databasePath UTF8String];
      
        //& is the C address-of unary operator. It returns the memory address of its operand.
    
       if (sqlite3_open(dbpath, &_contactDB) == SQLITE_OK)
       {
            char *errMsg;
            const char *sql_stmt =
           "CREATE TABLE IF NOT EXISTS CONTACTS (ID INTEGER PRIMARY KEY AUTOINCREMENT, NAME TEXT, ADDRESS TEXT, PHONE TEXT)";

            if (sqlite3_exec(_contactDB, sql_stmt, NULL, NULL, &errMsg) != SQLITE_OK)
            {
                 _status.text = @"Failed to create table";
            }
            sqlite3_close(_contactDB);
        } else {
                 _status.text = @"Failed to open/create database";
        }
     }
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)saveData:(id)sender {
     sqlite3_stmt    *statement;
     const char *dbpath = [_databasePath UTF8String];

     if (sqlite3_open(dbpath, &_contactDB) == SQLITE_OK)
     {
         

           NSString *insertSQL = [NSString stringWithFormat:
             @"INSERT INTO CONTACTS (name, address, phone) VALUES (\"%@\", \"%@\", \"%@\")",
             _name.text, _address.text, _phone.text];

           const char *insert_stmt = [insertSQL UTF8String];
           sqlite3_prepare_v2(_contactDB, insert_stmt,
             -1, &statement, NULL);
            if (sqlite3_step(statement) == SQLITE_DONE)
            {
                 _status.text = @"Contact added";
                 _name.text = @"";
                 _address.text = @"";
                 _phone.text = @"";
            } else {
                 _status.text = @"Failed to add contact";
            }
        lastId = [[NSNumber alloc] initWithLongLong:sqlite3_last_insert_rowid(_contactDB)];
         _strongNum = lastId;
         testVar = _strongNum;
         sqlite3_finalize(statement);
        sqlite3_close(_contactDB);
         //add button dynamically placed.
    }

}

- (IBAction)findContact:(id)sender {
     const char *dbpath = [_databasePath UTF8String];
     sqlite3_stmt    *statement;

     if (sqlite3_open(dbpath, &_contactDB) == SQLITE_OK)
     {
             NSString *querySQL = [NSString stringWithFormat:
               @"SELECT  id,address, phone FROM contacts WHERE name=\"%@\"",
               _name.text];

             const char *query_stmt = [querySQL UTF8String];

             if (sqlite3_prepare_v2(_contactDB,
                 query_stmt, -1, &statement, NULL) == SQLITE_OK)
             {
                     if (sqlite3_step(statement) == SQLITE_ROW)
                     {
                         
                         NSString *recordId= [[NSString alloc]
                                                   initWithUTF8String:
                                                   (const char *) sqlite3_column_text(
                                                                statement,0)];
                         
                         NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
                         NSString *documentsDirectory = [paths objectAtIndex:0];
                         NSString *appendPic = [NSString stringWithFormat:@"%@.png",recordId];
                         
                        NSString *imagePath = [documentsDirectory stringByAppendingPathComponent:appendPic];
                         

                         NSFileManager *filemgr;
            
                         
                         filemgr = [NSFileManager defaultManager];
                         if ([filemgr fileExistsAtPath:imagePath] == YES)
                             NSLog (@"File exists");
                         else
                             NSLog (@"File not found");
                         //   NSLog(@"%@",imagePath);
                         
                         NSLog(@"%@",imagePath);
                         NSData *jpgData = [NSData dataWithContentsOfFile:imagePath];
                         UIImage *image = [UIImage imageWithData:jpgData];
                         _recordView.image = image;
                       //  NSLo
                         
                /*
                         _imageFilenameURL = [NSURL URLWithString:imagePath];
                         ALAssetsLibrary * library = [[ALAssetsLibrary alloc] init];
                         [library assetForURL:_imageFilenameURL resultBlock: ^(ALAsset * asset) {
                             _recordView.image = [UIImage imageWithCGImage:[[asset defaultRepresentation] fullResolutionImage]];
                         } failureBlock: ^(NSError * error) {
                             NSLog(@"error : %@", error);
                         }];
                         
*/


                         //  _recordView.image =
                         
                         
                         
                         
                             NSString *addressField = [[NSString alloc]
                                initWithUTF8String:
                                (const char *) sqlite3_column_text(
                                  statement, 1)];
                             _address.text = addressField;
                             NSString *phoneField = [[NSString alloc]
                                 initWithUTF8String:(const char *)
                                 sqlite3_column_text(statement, 2)];
                             _phone.text = phoneField;
                             _status.text = @"Match found";
                     } else {
                             _status.text = @"Match not found";
                             _address.text = @"";
                             _phone.text = @"";
                     }
                     sqlite3_finalize(statement);
             }
             sqlite3_close(_contactDB);
     }

}

-(void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender{
   CameraViewController *camViewController = segue.destinationViewController;
    camViewController.idForPic = _strongNum;
}






- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    UITouch *touch = [[event allTouches] anyObject];
    if ([_name isFirstResponder] && [touch view] != _name) {
        [_name resignFirstResponder];
    }
    
    if ([_phone isFirstResponder] && [touch view] != _phone) {
        [_phone resignFirstResponder];
    }
    [super touchesBegan:touches withEvent:event];
}
@end
