//
//  BingoTimerViewController.m
//  BingoTimer
//
//  Created by Kristian Secor on 1/28/14.
//  Copyright (c) 2014 Kristian Secor. All rights reserved.
//

#import "BingoTimerViewController.h"

@interface BingoTimerViewController ()
@property (nonatomic, assign) int seconds;
@property (nonatomic, assign) int minutes;


@end

@implementation BingoTimerViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    self.secondsTimer = [NSTimer
                         scheduledTimerWithTimeInterval:1.0
                         target:self
                         selector:@selector(timerFireMethod:)
                         userInfo:nil
                         repeats:YES];
    self.seconds = 0;
    self.minutes = 0;}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void) timerFireMethod:(NSTimer *) theTimer
{
    self.seconds++;
    if (self.seconds == 60) {
        self.minutes++;
        self.seconds = 0;
    }
    
    self.secondsDisplay.text = [NSString
                                stringWithFormat:@"Seconds: %d", self.seconds];
    self.minutesDisplay.text = [NSString
                                stringWithFormat:@"Minutes: %d", self.minutes];
}


@end
