//
//  AddItemViewController.m
//  PlistTest
//
//  Created by Antti Myllykoski on 2/3/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "AddItemViewController.h"

@interface AddItemViewController ()

@end

@implementation AddItemViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

- (IBAction)addItem:(id)sender {
    if (_city.text.length == 0) {
        return;
    }
    if(_state.text.length == 0) {
        return;
    }
    [self saveData];
    [self.navigationController popViewControllerAnimated:YES];
}

- (IBAction) textFieldReturn:(id)textField
{
	[textField resignFirstResponder];
}

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    for (UIView * txt in self.view.subviews){
        if ([txt isKindOfClass:[UITextField class]] && [txt isFirstResponder]) {
            [txt resignFirstResponder];
        }
    }
}

-(void)saveData
{
	NSArray *paths = NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES);
	NSString *documentsPath = [paths objectAtIndex:0];
	NSString *plistPath = [documentsPath stringByAppendingPathComponent:@"Data.plist"];
	
	NSMutableArray *existingContent = [[NSMutableArray alloc] init];
    [self getExistingContent:existingContent];
    NSDictionary *plistDict = [NSDictionary dictionaryWithObjects: [NSArray arrayWithObjects: _city.text, _state.text, nil] forKeys:[NSArray arrayWithObjects: @"city", @"state", nil]];
    [existingContent addObject:plistDict];
    
	NSString *error = nil;
    NSData *plistData = [NSPropertyListSerialization dataFromPropertyList:existingContent format:NSPropertyListXMLFormat_v1_0 errorDescription:&error];
	
	if(plistData)
	{
        [plistData writeToFile:plistPath atomically:YES];
    }
    else
	{
        NSLog(@"Error in saveData: %@", error);
    }
}

-(void)getExistingContent:(NSMutableArray *)root
{
    NSArray *content = [[NSMutableArray alloc] init];
    NSArray *paths = NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES);
	NSString *documentsPath = [paths objectAtIndex:0];
	NSString *plistPath = [documentsPath stringByAppendingPathComponent:@"Data.plist"];
    
    // Use items from file system, if they exist
    if ([[NSFileManager defaultManager] fileExistsAtPath:documentsPath]) {
        content = [NSMutableArray  arrayWithContentsOfFile:plistPath ];
    }
    
    // Fallback to hardcoded items in the bundle to start with
    if (!content) {
        content = [[NSMutableArray alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"Data" ofType:@"plist"]];
    }
    
    for(int i = 0; i< content.count; i++){
        NSMutableDictionary* dict = [content objectAtIndex: i];
        [root addObject: dict];
    }
}
@end
