//
//  ViewController.m
//  fileUploader
//
//  Created by Kristian Secor on 2/17/13.
//  Copyright (c) 2013 Kristian Secor. All rights reserved.
//

#import "fileUploadDemoViewController.h"

@interface fileUploadDemoViewController ()

@end

@implementation fileUploadDemoViewController

@synthesize flUploadEngine = _flUploadEngine;
@synthesize flOperation = _flOperation;

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

- (IBAction)uploadPhoto:(id)sender {
    UIActionSheet *photoSourcePicker = [[UIActionSheet alloc] initWithTitle:nil
                                        delegate:self cancelButtonTitle:@"Cancel"
                                        destructiveButtonTitle:nil
                                        otherButtonTitles:	@"Take Photo",
                                        @"Choose from Library",
                                        nil,
                                        nil];
    
    [photoSourcePicker showInView:self.view];   
}

- (void)actionSheet:(UIActionSheet *)modalView clickedButtonAtIndex:(NSInteger)buttonIndex
{
	switch (buttonIndex)
	{
		case 0:
		{
            if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
                UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
                imagePicker.sourceType =  UIImagePickerControllerSourceTypeCamera;
                imagePicker.delegate = self;
                imagePicker.cameraFlashMode = UIImagePickerControllerCameraFlashModeOff;
                imagePicker.allowsEditing = NO;
                [self presentModalViewController:imagePicker animated:YES];
            }
            else {
                UIAlertView *alert;
                alert = [[UIAlertView alloc] initWithTitle:@"Error" 
                                                   message:@"This device doesn't have a camera." 
                                                  delegate:self cancelButtonTitle:@"Ok" 
                                         otherButtonTitles:nil];
                [alert show];                
            }
			break;
		}            
		case 1:
		{
            if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypePhotoLibrary]) {
                UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
                imagePicker.sourceType =  UIImagePickerControllerSourceTypePhotoLibrary;
                imagePicker.delegate = self;
                imagePicker.allowsEditing = NO;
                [self presentModalViewController:imagePicker animated:YES];
            }
            else {
                UIAlertView *alert;
                alert = [[UIAlertView alloc] initWithTitle:@"Error" 
                                                   message:@"This device doesn't support photo libraries." 
                                                  delegate:self cancelButtonTitle:@"Ok" 
                                         otherButtonTitles:nil];
                [alert show];                
            }            
			break;
		}
	}
}

- (void) imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    [self dismissModalViewControllerAnimated:YES];
    
    NSData *image = UIImageJPEGRepresentation([info objectForKey:UIImagePickerControllerOriginalImage], 0.1);
    
    self.flUploadEngine = [[fileUploadEngine alloc] initWithHostName:@"mm214.com" customHeaderFields:nil];

    NSMutableDictionary *postParams = [NSMutableDictionary dictionaryWithObjectsAndKeys:
                                       @"testApp", @"appID",
                                       nil];      
    self.flOperation = [self.flUploadEngine postDataToServer:postParams path:@"/test/post.php"];
    [self.flOperation addData:image forKey:@"userfl" mimeType:@"image/jpeg" fileName:@"upload.jpg"];
    
    [self.flOperation addCompletionHandler:^(MKNetworkOperation* operation) {
        NSLog(@"%@", [operation responseString]);
        /*   
            This is where you handle a successful 200 response
        */
    }     
    errorHandler:^(MKNetworkOperation *errorOp, NSError* error) {
        NSLog(@"%@", error);
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Error"
                                                        message:[error localizedDescription]
                                                       delegate:nil
                                              cancelButtonTitle:@"Dismiss"
                                              otherButtonTitles:nil];
        [alert show];        
    }];
    
    [self.flUploadEngine enqueueOperation:self.flOperation ];  
    
}
@end
