//
//  EditEmployees.swift
//  Employees
//
//  Created by Kristian Secor on 2/13/15.
//  Copyright (c) 2015 Kristian Secor. All rights reserved.
//




import UIKit
import CoreData

class EditEmployeesController:UIViewController,UITextFieldDelegate,UIPickerViewDataSource, UIPickerViewDelegate {

    
    
   
    @IBOutlet weak var fullName: UITextField!
    
    @IBOutlet weak var empId: UITextField!
    
    @IBOutlet weak var Salary: UITextField!
    
    @IBOutlet weak var Street: UITextField!
    
    @IBOutlet weak var City: UITextField!
    
    @IBOutlet weak var State: UITextField!
    
    @IBOutlet weak var Zip: UITextField!
    
    @IBOutlet weak var supPicker: UIPickerView!
    
    var managedObjectContext = (UIApplication.sharedApplication().delegate as AppDelegate).managedObjectContext
    
 
    var employee: Employees? = nil
    
    var supervisor: Supervisors? = nil
    
    var namesArray: [String] = []
    
    
    var choice:[String]? = nil

    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        var fetchRequest = NSFetchRequest(entityName: "Supervisors")
        fetchRequest.returnsObjectsAsFaults = false;
       var results: NSArray = managedObjectContext!.executeFetchRequest(fetchRequest, error: nil)!
        
        for res in results {
            var superVisorName = res.valueForKey("fullName") as String
            namesArray.append(superVisorName)
        }
        
        
        if employee != nil {

            
            fullName.text = employee?.fullName
            
            
            var myInt:NSNumber = employee?.empId as NSNumber!
            var idString:String = toString(myInt)
            empId.text = idString
            var mySalary:NSNumber = employee?.salary as NSNumber!
            var salaryString:String = toString(mySalary)
            Salary.text = salaryString
          
            Street.text = employee?.empToAddress.streetAddress
            City.text = employee?.empToAddress.city
            State.text = employee?.empToAddress.state
            Zip.text = employee?.empToAddress.zipcode
         
            var currSupervisor = employee?.empToSup.fullName
             var pickerIndex = find(namesArray,currSupervisor!)
        
       
            supPicker.selectRow(pickerIndex!, inComponent: 0, animated: true)

        }
       self.Zip.delegate = self
    }
    
    
    func numberOfComponentsInPickerView(pickerView: UIPickerView) -> Int {
        return 1
    }
    
    func pickerView(pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        return namesArray.count
    }
    
    func pickerView(pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String! {
        return namesArray[row]
    }

    func pickerView(pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int){
        var choice = namesArray[row]
    }
    
    @IBAction func done(sender: AnyObject) {
        if employee != nil {
            editEmployee()
        } else {
            createEmployee()
        }
        dismissViewController()
    }
    
    @IBAction func cancel(sender: AnyObject) {
        dismissViewController()
    }
    
    func dismissViewController() {
        navigationController?.popViewControllerAnimated(true)
    }
    
    func createEmployee() {
        let entityDescription = NSEntityDescription.entityForName("Employees", inManagedObjectContext: managedObjectContext!)
        let employee = Employees(entity: entityDescription!, insertIntoManagedObjectContext: managedObjectContext)
        employee.fullName = fullName.text
        
        var empIdString = empId.text
        
        var empIdNum = empIdString.toInt()
        employee.empId = empIdNum!
        
        var empSalary: NSDecimalNumber = NSDecimalNumber(string: Salary.text)

        employee.salary = empSalary
        let addressDescription = NSEntityDescription.entityForName("Addresses", inManagedObjectContext: managedObjectContext!)
        let address = Addresses(entity: addressDescription!, insertIntoManagedObjectContext: managedObjectContext)
        address.streetAddress = Street.text
        address.city = City.text
        address.state = State.text
        address.zipcode = Zip.text
        employee.empToAddress = address
        
   
        var rowPick = supPicker.selectedRowInComponent(0)
        var choice = namesArray[rowPick]
    
        
        var request = NSFetchRequest(entityName: "Supervisors")
        request.returnsObjectsAsFaults = false
        let predicate = NSPredicate(format: "fullName = %@",choice)
        request.predicate = predicate
        var supresults:NSArray = managedObjectContext!.executeFetchRequest(request, error: nil)!
    
        employee.empToSup  = supresults[0] as Supervisors
        
        managedObjectContext?.save(nil)
    }
    
    
   
    
    func editEmployee() {
         employee?.fullName = fullName.text
        
        var empIdString = empId.text
        var empIdNum = empIdString.toInt()
        employee?.empId = empIdNum!
        var empSalary: NSDecimalNumber = NSDecimalNumber(string: Salary.text)
        employee?.salary = empSalary
    
        employee?.empToAddress.streetAddress = Street.text
        employee?.empToAddress.city = City.text
        employee?.empToAddress.state = State.text
        employee?.empToAddress.zipcode = Zip.text
        
        var rowPick = supPicker.selectedRowInComponent(0)
        var choice = namesArray[rowPick]
        
        var request = NSFetchRequest(entityName: "Supervisors")
         request.returnsObjectsAsFaults = false
        let predicate = NSPredicate(format: "fullName = %@",choice)
        request.predicate = predicate

        var supresults:NSArray = self.managedObjectContext!.executeFetchRequest(request, error: nil)!
    
        println(supresults)

        employee?.empToSup  = supresults[0] as Supervisors
        managedObjectContext?.save(nil)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    func textFieldShouldReturn(textField: UITextField!) -> Bool {
        self.view.endEditing(true);
        return false;
    }
   
}

