import UIKit
import CoreData

class EditSupervisorsController:UIViewController {
    
    
    @IBOutlet weak var fullName: UITextField!
    
    @IBOutlet weak var deptName: UITextField!
    
    
    let managedObjectContext = (UIApplication.sharedApplication().delegate as AppDelegate).managedObjectContext
    
    
    var supervisor: Supervisors? = nil
    
    override func viewDidLoad() {
        super.viewDidLoad()
        if supervisor != nil {
            
            fullName.text = supervisor?.fullName
            deptName.text = supervisor?.deptName
            
            
        }
    }
    
    
    @IBAction func done(sender: AnyObject) {
        if supervisor != nil {
            editsupervisor()
        } else {
            createsupervisor()
        }
        dismissViewController()
    }
    
    @IBAction func cancel(sender: AnyObject) {
        dismissViewController()
    }
    
    func dismissViewController() {
        navigationController?.popViewControllerAnimated(true)
    }
    
    func createsupervisor() {
        let entityDescription = NSEntityDescription.entityForName("Supervisors", inManagedObjectContext: managedObjectContext!)
        let supervisor = Supervisors(entity: entityDescription!, insertIntoManagedObjectContext: managedObjectContext)
        
        supervisor.fullName = fullName.text
        supervisor.deptName = deptName.text
        managedObjectContext?.save(nil)
    }
    
    
    func editsupervisor() {
        supervisor?.fullName = fullName.text
        supervisor?.deptName = deptName.text
        
        managedObjectContext?.save(nil)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
}

