//
// EmployeesTableViewController.swift
//  Employees
//
//  Created by Kristian Secor on 2/13/15.
//  Copyright (c) 2015 Kristian Secor. All rights reserved.
//

import UIKit
import CoreData

class EmployeesTableViewController: UITableViewController, NSFetchedResultsControllerDelegate, UISearchBarDelegate,UISearchResultsUpdating, UISearchControllerDelegate {
    
    var searchController: UISearchController!
    var searchPredicate: NSPredicate? = nil
    
    var searchActive : Bool = false
    
    
    let managedObjectContext = (UIApplication.sharedApplication().delegate as AppDelegate).managedObjectContext
    
    var fetchedResultController: NSFetchedResultsController = NSFetchedResultsController()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        fetchedResultController = getFetchedResultController()
        fetchedResultController.delegate = self
        fetchedResultController.performFetch(nil)
        self.searchController = UISearchController(searchResultsController: nil)
        self.searchController.dimsBackgroundDuringPresentation = false
        self.searchController.searchResultsUpdater = self
        self.searchController.searchBar.sizeToFit()
        self.tableView.tableHeaderView = self.searchController?.searchBar
        self.tableView.delegate = self
        self.definesPresentationContext = true
        self.searchController.searchBar.delegate = self
        
        
    }
    
    func searchBarTextDidBeginEditing(searchBar: UISearchBar) {
        searchActive = true;
    }
    
    func searchBarTextDidEndEditing(searchBar: UISearchBar) {
        searchActive = false;
    }
    
    func searchBarCancelButtonClicked(searchBar: UISearchBar) {
        searchActive = false;
        self.searchPredicate = nil
        self.tableView.reloadData()
        
    }
    
    func searchBarSearchButtonClicked(searchBar: UISearchBar) {
        searchActive = false;
    }
    
    
    
    

    
    func updateSearchResultsForSearchController(searchController: UISearchController) {
        let searchText = self.searchController.searchBar.text
        if !searchText.isEmpty{
            self.searchPredicate = NSPredicate(format:"fullName contains[cd] %@",searchText)
        }
        
        self.tableView.reloadData()
    }
    
    
    
    
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject!) {
        if segue.identifier == "EditEmp" {
            if let indexPath = self.tableView.indexPathForSelectedRow() {
                
                let employee = self.searchPredicate == nil ?
                    self.fetchedResultController.objectAtIndexPath(indexPath) as Employees :
                    self.fetchedResultController.fetchedObjects?.filter() {
                        return self.searchPredicate!.evaluateWithObject($0)
                        }[indexPath.row] as Employees
                
                (segue.destinationViewController as EditEmployeesController).employee =  employee
            }
            
            
        }
    }
    
    
    func getFetchedResultController() -> NSFetchedResultsController {
        fetchedResultController = NSFetchedResultsController(fetchRequest: employeeFetchRequest(), managedObjectContext: managedObjectContext!, sectionNameKeyPath: nil, cacheName: nil)
        return fetchedResultController
    }
    
    func employeeFetchRequest() -> NSFetchRequest {
        let fetchRequest = NSFetchRequest(entityName: "Employees")
        let sortDescriptor = NSSortDescriptor(key: "fullName", ascending: true)
        
        fetchRequest.sortDescriptors = [sortDescriptor]
        
        return fetchRequest
    }
    
    
    
    // #pragma mark - Table view data source
    
    override func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        let numberOfSections = fetchedResultController.sections?.count
        return numberOfSections!
    }
    
    override func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if self.searchPredicate == nil {
            let sectionInfo = self.fetchedResultController.sections![section] as NSFetchedResultsSectionInfo
            return sectionInfo.numberOfObjects
        } else {
            let filteredObjects = self.fetchedResultController.fetchedObjects?.filter() {
                return self.searchPredicate!.evaluateWithObject($0)
            }
            if filteredObjects == nil{
                return 0
            }
            else
            {
                return filteredObjects!.count
            }
        }
    }
    
    override func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        var cell = tableView.dequeueReusableCellWithIdentifier("EmpCell", forIndexPath: indexPath) as UITableViewCell
        if self.searchPredicate == nil {
            let employee = fetchedResultController.objectAtIndexPath(indexPath) as Employees
            cell.textLabel?.text = employee.fullName
            
        }
        else
        {
            
            let employee = fetchedResultController.fetchedObjects?.filter(){
                return self.searchPredicate!.evaluateWithObject($0)
                }[indexPath.row] as Employees
            cell.textLabel?.text = employee.fullName
            
        }
        
        return cell
    }
    
    
    override func tableView(tableView: UITableView, commitEditingStyle editingStyle: UITableViewCellEditingStyle, forRowAtIndexPath indexPath: NSIndexPath) {
        let managedObject:NSManagedObject = fetchedResultController.objectAtIndexPath(indexPath) as NSManagedObject
        managedObjectContext?.deleteObject(managedObject)
        managedObjectContext?.save(nil)
    }
    
    func controllerWillChangeContent(controller: NSFetchedResultsController) {
        self.tableView.beginUpdates()
    }
    
    func controllerDidChangeContent(controller: NSFetchedResultsController) {
        self.tableView.endUpdates()
    }
    
    
    
    func controller(controller: NSFetchedResultsController, didChangeObject anObject: AnyObject, atIndexPath indexPath: NSIndexPath?, forChangeType type: NSFetchedResultsChangeType, newIndexPath: NSIndexPath?) {
        switch(type) {
        case NSFetchedResultsChangeType.Insert : self.tableView.insertRowsAtIndexPaths([newIndexPath!], withRowAnimation: UITableViewRowAnimation.Automatic)
            break
        case NSFetchedResultsChangeType.Delete : self.tableView.deleteRowsAtIndexPaths([indexPath!], withRowAnimation: UITableViewRowAnimation.Automatic)
            break
        case NSFetchedResultsChangeType.Update : self.tableView.reloadRowsAtIndexPaths([indexPath!], withRowAnimation: UITableViewRowAnimation.Automatic)
        default:
            println("Nothing")
        }
    }
    
    func controller(controller: NSFetchedResultsController, didChangeSection sectionInfo: NSFetchedResultsSectionInfo, atIndex sectionIndex: Int, forChangeType type: NSFetchedResultsChangeType) {
        switch(type) {
        case NSFetchedResultsChangeType.Insert : self.tableView.insertSections(NSIndexSet(index: sectionIndex), withRowAnimation: UITableViewRowAnimation.Automatic)
            break
        case NSFetchedResultsChangeType.Delete : self.tableView.deleteSections(NSIndexSet(index: sectionIndex), withRowAnimation: UITableViewRowAnimation.Automatic)
            break
        default:
            println("Nothing")
        }
    }
    
    
    
    
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
}
