//
//  ViewController.swift
//  MapData
//
//  Created by Kristian Secor on 2/11/15.
//  Copyright (c) 2015 Kristian Secor. All rights reserved.
//

import UIKit
import CoreData

class MasterTableViewController: UITableViewController, NSFetchedResultsControllerDelegate {
    
    
    
    
    //create an instance of the ManagedObjectContext
    var managedObjectContext: NSManagedObjectContext = (UIApplication.sharedApplication().delegate as AppDelegate).managedObjectContext!
    
    var fetchedResultController: NSFetchedResultsController = NSFetchedResultsController()
    
    

    override func viewDidLoad() {
        super.viewDidLoad()

        fetchedResultController = getFetchedResultController()
        fetchedResultController.delegate = self
        fetchedResultController.performFetch(nil)

        // Do any additional setup after loading the view, typically from a nib.
    }
    
    
    func getFetchedResultController()->NSFetchedResultsController{
        fetchedResultController = NSFetchedResultsController(fetchRequest: taskFetchRequest(),managedObjectContext: managedObjectContext, sectionNameKeyPath: nil, cacheName: nil)
        return fetchedResultController
    }
    
    func taskFetchRequest()->NSFetchRequest{
        let fetchRequest = NSFetchRequest(entityName: "Employees")
        //come back and explain
        let sortDescriptor = NSSortDescriptor(key:"name",ascending:false)
        fetchRequest.sortDescriptors = [sortDescriptor]
        return fetchRequest
    }
    
    
    // #pragma mark - Table view data source
    
    override func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        let numberOfSections = fetchedResultController.sections?.count
        return numberOfSections!
    }
    
    override func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        let numberOfRowsInSection = fetchedResultController.sections?[section].numberOfObjects
        return numberOfRowsInSection!
    }
    
    override func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        var cell = tableView.dequeueReusableCellWithIdentifier("Cell", forIndexPath: indexPath) as UITableViewCell
        let employee = fetchedResultController.objectAtIndexPath(indexPath) as Employees
        cell.textLabel?.text = employee.name
        cell.detailTextLabel?.text = employee.position
        return cell
    }
    
    
    override func tableView(tableView: UITableView, commitEditingStyle editingStyle: UITableViewCellEditingStyle, forRowAtIndexPath indexPath: NSIndexPath) {
        let managedObject:NSManagedObject = fetchedResultController.objectAtIndexPath(indexPath) as NSManagedObject
        managedObjectContext.deleteObject(managedObject)
        managedObjectContext.save(nil)
    }

    
    

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

