The Basic 15 Auto Layout Position Guides on XCode 6
==============

Before iPhone 6, basically we only have 2 screen sizes: 3.5 inches vs 4.0 inches. There 
are rumours that the are 2 sizes for iPhone 6: 4.7 inches and 5.5 inches. So starting from 
iOS 8 which will be released on late 2014, we might have 4 different screen sizes for 
iPhone.

With the 2 new screen resolution sizes, to be able to develop iOS apps using Auto Layout 
on storyboard is more important than ever. All the iOS developers will have to learn it 
sooner or later.

This Auto Layout project is a guide for iOS developers who are trying to learn Auto Layout.
The project contains the most basic positions that one single object can be positioned 
inside a view controller.

An object can have 3 different sizes:-
- The Object has fixed Height and Weight
- The Object has fixed Width but with flexible Height
- The Object has fixed Height but with flexible Width

The only potential object with flexible Width and flexible Height could be scrollview. 
To attach the scrollview using constraints is normally more straight forward compare with 
other objects.

The object can be located in 5 different positions:-
- Always at the Center of the SuperView
- Always stick to the Top Layout Guide
- Always stick to the Bottom Layout Guide
- Always stick to the Left side of the SuperView
- Always stick to the Right side of the SuperView

So by doing the math, we will have an object with 3 potential sizes in 5 potential 
positions, so, we will have a total of 3 x 5 = 15 different potential auto layout guides 
for one single object in a single view.

For more detail information about Auto Layout on XCode 6, please visit: [How to Use Auto Layout in XCode 6 for iOS 7 and 8 Development](http://mobileoop.com/how-to-use-auto-layout-in-xcode-6-for-ios-7-and-8-development "How to Use Auto Layout in XCode 6 for iOS 7 and 8 Development").

My website/Blog: [MobileOOP - iOS Mobile Application Development, Sharing and Tutorial](http://mobileoop.com/ "MobileOOP - iOS Mobile Application Development, Sharing and Tutorial").


