//
//  ViewController.swift
//  Camera
//
//  Created by Kristian Secor on 2/4/15.
//  Copyright (c) 2015 Kristian Secor. All rights reserved.
//

import UIKit
import MobileCoreServices

class ViewController: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {

    @IBOutlet weak var imageView: UIImageView!
    
    var newMedia:Bool?
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    
    
    @IBAction func useCamera(sender: AnyObject) {
        if UIImagePickerController.isSourceTypeAvailable(UIImagePickerControllerSourceType.Camera) {
            let imagePicker = UIImagePickerController()
            imagePicker.delegate = self
            imagePicker.sourceType = UIImagePickerControllerSourceType.Camera
            imagePicker.mediaTypes = [kUTTypeImage as NSString]
            imagePicker.allowsEditing = false
            self.presentViewController(imagePicker, animated: true, completion: nil)
            newMedia = true

        }
        
    }
    

    
    
    @IBAction func useCameraRoll(sender: AnyObject) {
        if UIImagePickerController.isSourceTypeAvailable(UIImagePickerControllerSourceType.SavedPhotosAlbum) {
            let imagePicker = UIImagePickerController()
            imagePicker.delegate = self
            imagePicker.sourceType = UIImagePickerControllerSourceType.PhotoLibrary
            imagePicker.mediaTypes = [kUTTypeImage as NSString]
            imagePicker.allowsEditing = false
            self.presentViewController(imagePicker, animated: true, completion: nil)
            newMedia = false
            
        }
    }
    
    
    func imagePickerController(picker:UIImagePickerController, didFinishPickingMediaWithInfo info: [NSObject:AnyObject]){
         //what happens after the picture is chosen
        let mediaType = info[UIImagePickerControllerMediaType] as NSString
        self.dismissViewControllerAnimated(true, completion: nil)
        if mediaType.isEqualToString(kUTTypeImage as NSString){
            let image = info[UIImagePickerControllerOriginalImage] as UIImage
            imageView.image = image
            if (newMedia == true){
                UIImageWriteToSavedPhotosAlbum(image, self, "image:didFinishSavingWithError:contextInfo:", nil)
               
            }
        }
    }
    
    
    func image(image:UIImage,didFinishSavingWithError error:NSErrorPointer,contextInfo:UnsafePointer<Void>){
        //this tells us if and why we can't save a pic
        if error != nil {
            let alert = UIAlertController(title:"Save Failed",message:"Failed to Save Image",preferredStyle:UIAlertControllerStyle.Alert)
            let cancelAction = UIAlertAction(title:"OK", style: .Cancel, handler:nil)
            alert.addAction(cancelAction)
            self.presentViewController(alert, animated: true, completion: nil)
        }
    }
    
     func imagePickerControllerDidCancel(picker: UIImagePickerController) {
        //the user cancels the controller
        self.dismissViewControllerAnimated(true, completion: nil)
    }
    
    
    
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

