//
//  ViewController.swift
//  MapKit
//
//  Created by Kristian Secor on 2/4/15.
//  Copyright (c) 2015 Kristian Secor. All rights reserved.
//

import UIKit
import MapKit

class ViewController: UIViewController {

    @IBOutlet weak var mapView: MKMapView!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        //get location
        
        let location = CLLocationCoordinate2D(latitude: 32.76, longitude: -117.23)
        let span = MKCoordinateSpanMake(0.05, 0.05)
        let region = MKCoordinateRegion(center: location, span: span)
        mapView.setRegion(region, animated: true)
        let annotation = MKPointAnnotation()
        annotation.setCoordinate(location)
        annotation.title = "La Vela Paz"
        annotation.subtitle = "San Diego"
        mapView.addAnnotation(annotation)
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

