//
//  ViewController.swift
//  JSON
//
//  Created by Kristian Secor on 3/11/15.
//  Copyright (c) 2015 Kristian Secor. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var timeLabel: UILabel!
    override func viewDidLoad() {
        super.viewDidLoad()
        
        let urlAsString = "http://date.jsontest.com"
        let url = NSURL(string:urlAsString)!

        let urlSession = NSURLSession.sharedSession()
        
        let jsonQuery = urlSession.dataTaskWithURL(url, completionHandler:{data,response, error -> Void in
            if error != nil {
                println(error.localizedDescription)
            }
        var err:NSError?
            var jsonResult = NSJSONSerialization.JSONObjectWithData(data,options: NSJSONReadingOptions.MutableContainers,error:&err) as NSDictionary
            if err != nil {
                println("JSON ERROR \(err!.localizedDescription)")
            }
/*
{
time: "01:09:50 AM",
milliseconds_since_epoch: 1426122590536,
date: "03-12-2015"
}*/
        
            let JSONDate:String! = jsonResult["date"] as String
            let jsonTime:String! = jsonResult["time"] as String
            
            dispatch_async(dispatch_get_main_queue(),{
              self.timeLabel.text = "\(JSONDate) and \(jsonTime)"
    
            })
    
        })
        jsonQuery.resume()
        
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

