//
//  BingoAppDelegate.m
//  BingoGame
//
//  Created by Jenny Wu on 11/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "BingoAppDelegate.h"


@implementation BingoAppDelegate
int const HISTORYTABBAR_INDEX = 0;
int const GAMETABBAR_INDEX = 1;
int const BINGOTABBAR_INDEX = 2;

-(int)historyTabItemIndex{
    return HISTORYTABBAR_INDEX;
}

-(int)bingoTabItemIndex{
    return BINGOTABBAR_INDEX;
}

-(void)startNewGame{
    [self getNewGame];
    [self showGameTab];
    
    UITabBarController *tabBarController = (UITabBarController *)self.window.rootViewController;
    UITabBar *tabBar = tabBarController.tabBar;
    
    UITabBarItem *bingoItem = [tabBar.items objectAtIndex: BINGOTABBAR_INDEX];
    bingoItem.badgeValue = nil;
}

-(void)showGameTab{
    //Make the New Game Tab the start up tab
    if ([self.window.rootViewController isKindOfClass:[UITabBarController class]]){
        UITabBarController *controller = (UITabBarController *)self.window.rootViewController;
        controller.selectedIndex = GAMETABBAR_INDEX;
    }
}

-(void)getNewGame{
    self.currentGameBoard = [[Gameboard alloc] initNewGameWithRowSize:5];
    [self.currentGameBoard saveGameBoard];
}

-(void)getLastGame{
    self.currentGameBoard = [Gameboard getLastGame];
}

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    // Override point for customization after application launch.
    self.bingodatabase = [[BingoDatabase alloc] init];
    [self.bingodatabase createDatabaseSchema];
    UITabBarController *tabBarController = (UITabBarController *)self.window.rootViewController;
    UITabBar *tabBar = tabBarController.tabBar;
    
    UITabBarItem *bingoItem = [tabBar.items objectAtIndex: BINGOTABBAR_INDEX];
    bingoItem.selectedImage = [UIImage imageNamed:@"BingoSelected"];
    
    UITabBarItem *gameItem = [tabBar.items objectAtIndex:GAMETABBAR_INDEX];
    gameItem.selectedImage = [UIImage imageNamed:@"GameSelected"];
    
    [[UIBarButtonItem appearanceWhenContainedIn:[UINavigationBar class], nil] setTitleTextAttributes:
     @{NSFontAttributeName : [UIFont boldSystemFontOfSize:20.0]} forState:UIControlStateNormal];
    
    [self getLastGame];
    if (!self.currentGameBoard){
        [self getNewGame];
    }
    
    //Make the New Game Tab the start up tab
    [self showGameTab];
    return YES;
}
							
- (void)applicationWillResignActive:(UIApplication *)application
{
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later. 
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}


@end
